/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class OverridablePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final String CLASSPATH = "classpath:";
    private String systemPropertyName;
    private Map<String, String> resolvedProps;

    public void setLocation(Resource location) {
        if (StringUtils.isBlank((CharSequence)this.getSystemPropertyName())) {
            throw new IllegalArgumentException("Missing value for 'systemPropertyName'.");
        }
        String overrideProperty = System.getProperty(this.getSystemPropertyName());
        Object locationResource = StringUtils.isBlank((CharSequence)overrideProperty) ? location : (overrideProperty.startsWith(CLASSPATH) ? new ClassPathResource(overrideProperty.substring(CLASSPATH.length())) : new FileSystemResource(overrideProperty));
        super.setLocation(locationResource);
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.resolvedProps = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            this.resolvedProps.put(keyStr, this.resolvePlaceholder(keyStr, props, 2));
        }
    }

    public void setSystemPropertyName(String systemPropertyName) {
        this.systemPropertyName = systemPropertyName;
    }

    public String getSystemPropertyName() {
        return this.systemPropertyName;
    }

    public Map<String, String> getResolvedProps() {
        return Collections.unmodifiableMap(this.resolvedProps);
    }
}

