/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.opensocial.service.impl;

import org.apache.rave.exception.ResourceNotFoundException;
import org.apache.rave.model.Page;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetStatus;
import org.apache.rave.portal.model.impl.RegionImpl;
import org.apache.rave.portal.model.impl.RegionWidgetImpl;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.provider.opensocial.repository.GadgetMetadataRepository;
import org.apache.rave.provider.opensocial.service.OpenSocialService;
import org.apache.rave.provider.opensocial.service.SecurityTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultOpenSocialService
implements OpenSocialService {
    protected final GadgetMetadataRepository gadgetMetadataRepository;
    protected final WidgetService widgetService;
    protected final PageService pageService;
    protected final SecurityTokenService tokenService;

    @Autowired
    public DefaultOpenSocialService(GadgetMetadataRepository gadgetMetadataRepository, WidgetService widgetService, PageService pageService, SecurityTokenService tokenService) {
        this.gadgetMetadataRepository = gadgetMetadataRepository;
        this.widgetService = widgetService;
        this.pageService = pageService;
        this.tokenService = tokenService;
    }

    @Override
    public String getGadgetMetadata(String gadgetUrl) {
        return this.gadgetMetadataRepository.getGadgetMetadata(gadgetUrl);
    }

    @Override
    public String getEncryptedSecurityToken(String pageId, String url) {
        Widget widget = this.widgetService.getWidgetByUrl(url);
        Page page = this.pageService.getPage(pageId);
        this.validate(widget);
        RegionWidgetImpl regionWidget = new RegionWidgetImpl(String.valueOf(System.currentTimeMillis()), "-1", (Region)new RegionImpl("-1", page, -1));
        return this.tokenService.getEncryptedSecurityToken((RegionWidget)regionWidget, widget);
    }

    @Override
    public String getEncryptedSecurityToken(org.apache.rave.rest.model.RegionWidget item) {
        return this.tokenService.getEncryptedSecurityToken(item.getId(), item.getWidgetUrl(), item.getOwnerId());
    }

    protected void validate(Widget widget) {
        if (widget == null) {
            throw new ResourceNotFoundException("The requested gadget does not exist in the gadget store.");
        }
        if (widget.getWidgetStatus().equals((Object)WidgetStatus.PREVIEW)) {
            throw new IllegalStateException("The requested gadget exists in the gadget store but is not published.");
        }
    }
}

