/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.w3c.service.impl;

import org.apache.rave.model.Widget;
import org.apache.rave.portal.service.WidgetMetadataResolver;
import org.apache.rave.portal.service.WidgetProviderService;
import org.apache.rave.provider.w3c.repository.W3CWidgetMetadataRepository;
import org.apache.rave.provider.w3c.repository.impl.WookieWidgetMetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class WookieWidgetMetadataResolver
implements WidgetMetadataResolver {
    private static Logger logger = LoggerFactory.getLogger(WookieWidgetMetadataResolver.class);
    private W3CWidgetMetadataRepository widgetMetadataRepository;

    @Autowired
    public WookieWidgetMetadataResolver(@Qualifier(value="wookieWidgetService") WidgetProviderService widgetService) {
        this.widgetMetadataRepository = new WookieWidgetMetadataRepository(widgetService);
    }

    public String getSupportedContext() {
        return "W3C";
    }

    public Widget getMetadata(String url) {
        try {
            return this.widgetMetadataRepository.getWidgetMetadata(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error occurred while processing response for Widget metadata call", e);
        }
    }

    public Widget[] getMetadataGroup(String url) {
        try {
            return this.widgetMetadataRepository.getWidgetMetadata();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error occurred while processing response for Widget (group) metadata call", e);
        }
    }

    public Widget publishRemote(String url) {
        return this.widgetMetadataRepository.publishRemote(url);
    }
}

