/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc;

import org.apache.rave.model.Widget;
import org.apache.rave.portal.service.WidgetMarketplaceService;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.api.rpc.model.RpcOperation;
import org.apache.rave.portal.web.api.rpc.model.RpcResult;
import org.apache.rave.portal.web.validator.NewWidgetValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="rpcMarketplaceApi")
@RequestMapping(value={"/api/rpc/marketplace/*"})
public class MarketplaceAPI {
    private static final Logger logger = LoggerFactory.getLogger(MarketplaceAPI.class);
    private final WidgetMarketplaceService marketplaceService;
    private final NewWidgetValidator widgetValidator;
    private final WidgetService widgetService;

    @Autowired
    public MarketplaceAPI(WidgetMarketplaceService marketplaceService, NewWidgetValidator validator, WidgetService widgetService) {
        this.marketplaceService = marketplaceService;
        this.widgetValidator = validator;
        this.widgetService = widgetService;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"add"})
    public RpcResult<Widget> add(final @RequestParam String url, final @RequestParam String providerType) {
        return new RpcOperation<Widget>(){

            @Override
            public Widget execute() {
                Widget widget = null;
                try {
                    widget = MarketplaceAPI.this.marketplaceService.resolveWidgetMetadata(url, providerType);
                    if (widget == null) {
                        return null;
                    }
                    BeanPropertyBindingResult results = new BeanPropertyBindingResult((Object)widget, "widget");
                    MarketplaceAPI.this.widgetValidator.validate(widget, (Errors)results);
                    if (results.hasErrors()) {
                        if (results.hasFieldErrors("url") && results.getFieldError("url").toString().contains("widget.url.exists")) {
                            return MarketplaceAPI.this.widgetService.getWidgetByUrl(widget.getUrl());
                        }
                        return null;
                    }
                    return MarketplaceAPI.this.marketplaceService.addWidget(widget);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    return null;
                }
            }
        }.getResult();
    }
}

