/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import org.apache.rave.model.PortalPreference;
import org.apache.rave.model.User;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetMarketplaceService;
import org.apache.rave.portal.web.controller.util.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/marketplace/*", "/marketplace"})
public class WidgetMarketplaceController {
    private static final int MAXIMUM_WIDGETS_PER_PAGE = 10;
    private static final Logger logger = LoggerFactory.getLogger(WidgetMarketplaceController.class);
    private final WidgetMarketplaceService marketplaceService;
    private final UserService userService;
    private final PortalPreferenceService preferenceService;

    @Autowired
    public WidgetMarketplaceController(WidgetMarketplaceService marketplaceService, PortalPreferenceService preferenceService, UserService userService) {
        this.marketplaceService = marketplaceService;
        this.preferenceService = preferenceService;
        this.userService = userService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String viewSearchResult(Model model, @RequestParam String referringPageId, @RequestParam(required=false, defaultValue="0") int offset) {
        String view = "templates.user.addwidget.marketplace";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.addwidget.marketplace");
        try {
            model.addAttribute("widgets", (Object)this.marketplaceService.getWidgetsByFreeTextSearch("", offset, this.getPageSize()));
            model.addAttribute("categories", (Object)this.marketplaceService.getCategories());
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)"Marketplace not available");
        }
        model.addAttribute("offset", (Object)offset);
        model.addAttribute("searchTerm", (Object)"");
        return "templates.user.addwidget.marketplace";
    }

    @RequestMapping(value={"marketplace/search"}, method={RequestMethod.GET})
    public String viewSearchResult(Model model, @RequestParam String referringPageId, @RequestParam String searchTerm, @RequestParam(required=false, defaultValue="0") int offset) {
        String view = "templates.user.addwidget.marketplace";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.addwidget.marketplace");
        try {
            model.addAttribute("widgets", (Object)this.marketplaceService.getWidgetsByFreeTextSearch(searchTerm, offset, this.getPageSize()));
            model.addAttribute("categories", (Object)this.marketplaceService.getCategories());
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)"Marketplace not available");
        }
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("offset", (Object)offset);
        return "templates.user.addwidget.marketplace";
    }

    @RequestMapping(value={"category/{category}"}, method={RequestMethod.GET})
    public String viewCategory(Model model, @RequestParam String referringPageId, @PathVariable String category, @RequestParam(required=false, defaultValue="0") int offset) {
        String view = "templates.user.addwidget.marketplace";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.addwidget.marketplace");
        try {
            if (category.equals("0")) {
                model.addAttribute("widgets", (Object)this.marketplaceService.getWidgetsByFreeTextSearch("", offset, this.getPageSize()));
                model.addAttribute("categories", (Object)this.marketplaceService.getCategories());
            } else {
                model.addAttribute("widgets", (Object)this.marketplaceService.getWidgetsByCategory(category, offset, this.getPageSize()));
                model.addAttribute("categories", (Object)this.marketplaceService.getCategories());
                model.addAttribute("selectedCategory", (Object)category);
            }
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)"Marketplace not available");
        }
        model.addAttribute("category", (Object)category);
        model.addAttribute("offset", (Object)offset);
        return "templates.user.addwidget.marketplace";
    }

    @RequestMapping(value={"widget/{widget}"}, method={RequestMethod.GET})
    public String viewWidgetDetail(Model model, @RequestParam String referringPageId, @RequestParam String externalId, @PathVariable String widget) {
        String view = "templates.user.widget.marketplace";
        User user = this.userService.getAuthenticatedUser();
        this.widgetStoreModelHelper(model, referringPageId, user, "templates.user.widget.marketplace");
        try {
            model.addAttribute("widget", (Object)this.marketplaceService.getWidget(externalId));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)"Marketplace not available");
        }
        return "templates.user.widget.marketplace";
    }

    private int getPageSize() {
        PortalPreference pageSizePref = this.preferenceService.getPreference("pageSize");
        if (pageSizePref == null) {
            return 10;
        }
        try {
            return Integer.parseInt(pageSizePref.getValue());
        }
        catch (NumberFormatException e) {
            return 10;
        }
    }

    private void widgetStoreModelHelper(Model model, String referringPageId, User user, String view) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        ControllerUtils.addNavItemsToModel(view, model, referringPageId, user);
    }
}

