/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.apache.rave.model.Authority;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.impl.UserImpl;
import org.apache.rave.portal.service.AuthorityService;
import org.apache.rave.portal.service.NewAccountService;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.admin.AdminControllerUtil;
import org.apache.rave.portal.web.controller.util.ModelUtils;
import org.apache.rave.portal.web.model.UserForm;
import org.apache.rave.portal.web.validator.NewAccountValidator;
import org.apache.rave.portal.web.validator.UserProfileValidator;
import org.apache.rave.rest.model.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"user", "tokencheck"})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private static final String SELECTED_ITEM = "users";
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorityService authorityService;
    @Autowired
    private UserProfileValidator userProfileValidator;
    @Autowired
    private PortalPreferenceService preferenceService;
    @Autowired
    private NewAccountValidator newAccountValidator;
    @Autowired
    private NewAccountService newAccountService;
    @Value(value="#{messages['page.newaccount.message.created']}")
    private String messageSuccess;

    @InitBinder(value={"user"})
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(GrantedAuthority.class, (PropertyEditor)new AuthorityEditor());
        dataBinder.registerCustomEditor(Authority.class, (PropertyEditor)new AuthorityEditor());
        dataBinder.setDisallowedFields(new String[]{"entityId", "username", "password", "confirmPassword"});
    }

    @RequestMapping(value={"/admin/users"}, method={RequestMethod.GET})
    public String viewUsers(@RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false) String action, @RequestParam(required=false) String referringPageId, Model model) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        SearchResult users = this.userService.getLimitedList(offset, this.getPageSize());
        model.addAttribute("searchResult", (Object)users);
        if (AdminControllerUtil.isDeleteOrUpdate(action)) {
            model.addAttribute("actionresult", (Object)action);
        }
        return "templates.admin.users";
    }

    @RequestMapping(value={"/admin/users/search"}, method={RequestMethod.GET})
    public String searchUsers(@RequestParam(required=true) String searchTerm, @RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false) String referringPageId, Model model) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        SearchResult users = this.userService.getUsersByFreeTextSearch(searchTerm, offset, this.getPageSize());
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("searchResult", (Object)users);
        return "templates.admin.users";
    }

    @RequestMapping(value={"/admin/userdetail/{userid}"}, method={RequestMethod.GET})
    public String viewUserDetail(@PathVariable(value="userid") String userid, @RequestParam(required=false) String referringPageId, Model model) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        model.addAttribute("user", (Object)this.userService.getUserById(userid));
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        return "templates.admin.userdetail";
    }

    @RequestMapping(value={"/admin/userdetail/update"}, method={RequestMethod.POST})
    public String updateUserDetail(@ModelAttribute User user, BindingResult result, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, @RequestParam(required=false) String referringPageId, ModelMap modelMap, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        user.setConfirmPassword(user.getPassword());
        this.userProfileValidator.validate(user, (Errors)result);
        if (result.hasErrors()) {
            modelMap.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, (Model)modelMap, referringPageId);
            return "templates.admin.userdetail";
        }
        this.userService.updateUserProfile(user);
        modelMap.clear();
        status.setComplete();
        return "redirect:/app/admin/users?action=update&referringPageId=" + referringPageId;
    }

    @RequestMapping(value={"/admin/userdetail/delete"}, method={RequestMethod.POST})
    public String deleteUserDetail(@ModelAttribute User user, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, @RequestParam(required=false) String confirmdelete, @RequestParam(required=false) String referringPageId, ModelMap modelMap, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        if (!Boolean.parseBoolean(confirmdelete)) {
            modelMap.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, (Model)modelMap, referringPageId);
            modelMap.addAttribute("missingConfirm", (Object)true);
            return "templates.admin.userdetail";
        }
        this.userService.deleteUser(user.getId());
        modelMap.clear();
        status.setComplete();
        return "redirect:/app/admin/users?action=delete&referringPageId=" + referringPageId;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/admin/adduser"})
    public String setUpForm(ModelMap model, @RequestParam(required=false) String referringPageId) {
        logger.debug("Initializing new account form");
        model.addAttribute("referringPageId", (Object)referringPageId);
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, (Model)model, referringPageId);
        model.addAttribute("newUser", (Object)new UserImpl());
        return "templates.admin.newaccount";
    }

    @RequestMapping(value={"/admin/newaccount", "/admin/newaccount/*"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="newUser") UserForm newUser, BindingResult results, Model model, @RequestParam(required=false) String referringPageId, RedirectAttributes redirectAttributes) {
        logger.debug("Creating a new user account");
        model.addAttribute("newUser", (Object)newUser);
        this.newAccountValidator.validate(newUser, (Errors)results);
        if (results.hasErrors()) {
            logger.info("newaccount.jsp: shows validation errors");
            model.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
            return "templates.admin.newaccount";
        }
        try {
            logger.debug("newaccount.jsp: passed form validation");
            this.newAccountService.createNewAccount(ModelUtils.convert(newUser));
            redirectAttributes.addFlashAttribute("message", (Object)this.messageSuccess);
            return "redirect:/app/admin/users?referringPageId=" + referringPageId;
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            model.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
            logger.info("Account creation failed: ", (Throwable)ex);
            results.reject("Account already exists", "Unable to create account");
            return "templates.admin.newaccount";
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.error("Account creation failed: ", (Throwable)ex);
            } else {
                logger.error("Account creation failed: {}", (Object)ex.getMessage());
            }
            results.reject("Unable to create account:" + ex.getMessage(), "Unable to create account");
            model.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
            return "templates.admin.newaccount";
        }
    }

    @ModelAttribute(value="authorities")
    public SearchResult<Authority> populateAuthorityList() {
        return this.authorityService.getAllAuthorities();
    }

    @ModelAttribute(value="loggedInUser")
    public String populateLoggedInUsername() {
        return this.userService.getAuthenticatedUser().getUsername();
    }

    void setUserService(UserService userService) {
        this.userService = userService;
    }

    void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    void setUserProfileValidator(UserProfileValidator userProfileValidator) {
        this.userProfileValidator = userProfileValidator;
    }

    void setPreferenceService(PortalPreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    void setNewAccountValidator(NewAccountValidator newAccountValidator) {
        this.newAccountValidator = newAccountValidator;
    }

    void setNewAccountService(NewAccountService newAccountService) {
        this.newAccountService = newAccountService;
    }

    public int getPageSize() {
        PortalPreference pageSizePref = this.preferenceService.getPreference("pageSize");
        if (pageSizePref == null) {
            return 10;
        }
        try {
            return Integer.parseInt(pageSizePref.getValue());
        }
        catch (NumberFormatException e) {
            return 10;
        }
    }

    private class AuthorityEditor
    extends PropertyEditorSupport {
        private AuthorityEditor() {
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            Authority authority = UserController.this.authorityService.getAuthorityByName(text);
            this.setValue(authority);
        }
    }
}

