/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import java.beans.PropertyEditor;
import org.apache.rave.model.Category;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetStatus;
import org.apache.rave.portal.service.CategoryService;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.controller.admin.AdminControllerUtil;
import org.apache.rave.portal.web.controller.util.CategoryEditor;
import org.apache.rave.portal.web.validator.UpdateWidgetValidator;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@SessionAttributes(value={"widget", "tokencheck"})
public class WidgetController {
    private static final String SELECTED_ITEM = "widgets";
    @Autowired
    private WidgetService widgetService;
    @Autowired
    private UpdateWidgetValidator widgetValidator;
    @Autowired
    private PortalPreferenceService preferenceService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private CategoryEditor categoryEditor;

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"entityId"});
        dataBinder.registerCustomEditor(Category.class, (PropertyEditor)this.categoryEditor);
    }

    @RequestMapping(value={"/admin/widgets"}, method={RequestMethod.GET})
    public String viewWidgets(@RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false) String action, @RequestParam(required=false) String referringPageId, Model model) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        SearchResult widgets = this.widgetService.getLimitedList(offset, this.getPageSize());
        model.addAttribute("searchResult", (Object)widgets);
        if (AdminControllerUtil.isDeleteOrUpdate(action)) {
            model.addAttribute("actionresult", (Object)action);
        }
        return "templates.admin.widgets";
    }

    @RequestMapping(value={"/admin/widgets/search"}, method={RequestMethod.GET})
    public String searchWidgets(@RequestParam(required=false) String searchTerm, @RequestParam(required=false) String widgettype, @RequestParam(required=false) String widgetstatus, @RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false) String referringPageId, Model model) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        SearchResult widgets = this.widgetService.getWidgetsBySearchCriteria(searchTerm, widgettype, widgetstatus, offset, this.getPageSize());
        model.addAttribute("searchResult", (Object)widgets);
        model.addAttribute("searchTerm", (Object)searchTerm);
        model.addAttribute("selectedWidgetType", (Object)widgettype);
        model.addAttribute("selectedWidgetStatus", (Object)widgetstatus);
        return "templates.admin.widgets";
    }

    @RequestMapping(value={"/admin/widgetdetail/{widgetid}"}, method={RequestMethod.GET})
    public String viewWidgetDetail(@PathVariable(value="widgetid") String widgetid, @RequestParam(required=false) String referringPageId, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        model.addAttribute("referringPageId", (Object)referringPageId);
        model.addAttribute("widget", (Object)this.widgetService.getWidget(widgetid));
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        model.addAttribute("categories", (Object)this.categoryService.getAllList());
        return "templates.admin.widgetdetail";
    }

    @RequestMapping(value={"/admin/widgetdetail/update"}, method={RequestMethod.POST})
    public String updateWidgetDetail(@ModelAttribute(value="widget") Widget widget, BindingResult result, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, @RequestParam(required=false) String referringPageId, ModelMap modelMap, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        this.widgetValidator.validate(widget, (Errors)result);
        if (result.hasErrors()) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, (Model)modelMap, referringPageId);
            modelMap.addAttribute("referringPageId", (Object)referringPageId);
            modelMap.addAttribute("categories", (Object)this.categoryService.getAllList());
            return "templates.admin.widgetdetail";
        }
        this.widgetService.updateWidget(widget);
        modelMap.clear();
        status.setComplete();
        return "redirect:/app/admin/widgets?action=update&referringPageId=" + referringPageId;
    }

    @ModelAttribute(value="widgetStatus")
    public WidgetStatus[] getWidgetStatusValues() {
        return WidgetStatus.values();
    }

    void setWidgetService(WidgetService widgetService) {
        this.widgetService = widgetService;
    }

    void setWidgetValidator(UpdateWidgetValidator widgetValidator) {
        this.widgetValidator = widgetValidator;
    }

    public void setPreferenceService(PortalPreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void setCategoryEditor(CategoryEditor categoryEditor) {
        this.categoryEditor = categoryEditor;
    }

    public int getPageSize() {
        PortalPreference pageSizePref = this.preferenceService.getPreference("pageSize");
        if (pageSizePref == null) {
            return 10;
        }
        try {
            return Integer.parseInt(pageSizePref.getValue());
        }
        catch (NumberFormatException e) {
            return 10;
        }
    }
}

