/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.rave.portal.web.model.PortalPreferenceForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class PortalPreferenceFormValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return PortalPreferenceForm.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        PortalPreferenceForm form = (PortalPreferenceForm)target;
        this.validateRequiredFields(errors);
        this.validatePageSize(form, errors);
    }

    private void validateRequiredFields(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"pageSize.value", (String)"form.field.error.required");
    }

    private void validatePageSize(PortalPreferenceForm form, Errors errors) {
        if (form.getPageSize() != null) {
            int pageSizeValue;
            try {
                pageSizeValue = Integer.parseInt(form.getPageSize().getValue());
            }
            catch (NumberFormatException e) {
                pageSizeValue = 0;
            }
            if (pageSizeValue <= 0) {
                errors.rejectValue("pageSize.value", "admin.preferencedetail.pageSize.malformed");
            }
        }
    }
}

