/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.implementations.Canonicalizer11_OmitComments;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315OmitComments;
import org.apache.xml.security.parser.XMLParserException;
import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Node;

public abstract class XMLSignatureInput {
    private Set<Node> inputNodeSet;
    private Node subNode;
    private boolean isNodeSet;
    private final List<NodeFilter> nodeFilters = new ArrayList<NodeFilter>();
    private Node excludeNode;
    private boolean excludeComments;
    private String sourceURI;
    private String mimeType;
    private boolean needsToBeExpanded;
    private boolean secureValidation = true;
    private OutputStream outputStream;

    protected XMLSignatureInput() {
    }

    protected XMLSignatureInput(Node rootNode) {
        this.subNode = rootNode;
    }

    protected XMLSignatureInput(Set<Node> nodeSet) {
        this.inputNodeSet = nodeSet;
    }

    public abstract boolean hasUnprocessedInput();

    public abstract InputStream getUnprocessedInput() throws IOException;

    protected abstract Node convertToNode() throws XMLParserException, IOException;

    public void write(OutputStream output) throws CanonicalizationException, IOException {
        this.write(output, false);
    }

    public abstract void write(OutputStream var1, boolean var2) throws CanonicalizationException, IOException;

    public Set<Node> getInputNodeSet() {
        return this.inputNodeSet;
    }

    public Set<Node> getNodeSet() throws XMLParserException, IOException {
        return this.getNodeSet(false);
    }

    private Set<Node> getNodeSet(boolean circumvent) throws XMLParserException, IOException {
        if (this.inputNodeSet != null) {
            return this.inputNodeSet;
        }
        if (this.subNode != null) {
            if (circumvent) {
                XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this.subNode));
            }
            this.inputNodeSet = new LinkedHashSet<Node>();
            XMLUtils.getSet(this.subNode, this.inputNodeSet, this.excludeNode, this.excludeComments);
            return this.inputNodeSet;
        }
        if (this.hasUnprocessedInput()) {
            this.subNode = this.convertToNode();
            LinkedHashSet<Node> result = new LinkedHashSet<Node>();
            XMLUtils.getSet(this.subNode, result, null, false);
            return result;
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public Node getSubNode() {
        return this.subNode;
    }

    public void addNodeFilter(NodeFilter filter) throws XMLParserException, IOException {
        if (this.hasUnprocessedInput()) {
            this.subNode = this.convertToNode();
        }
        this.nodeFilters.add(filter);
    }

    public final List<NodeFilter> getNodeFilters() {
        return this.nodeFilters;
    }

    public final void setNodeSet(boolean nodeSet) {
        this.isNodeSet = nodeSet;
    }

    public byte[] getBytes() throws IOException, CanonicalizationException {
        if (this.hasUnprocessedInput()) {
            return JavaUtils.getBytesFromStream(this.getUnprocessedInput());
        }
        if (this.isElement() || this.isNodeSet()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.canonicalize(baos, false);
            return baos.toByteArray();
        }
        return null;
    }

    public boolean isNodeSet() {
        return this.isNodeSet || this.inputNodeSet != null;
    }

    public boolean isElement() {
        return this.subNode != null && this.inputNodeSet == null && !this.isNodeSet;
    }

    public String getPreCalculatedDigest() {
        return null;
    }

    public Node getExcludeNode() {
        return this.excludeNode;
    }

    public void setExcludeNode(Node excludeNode) {
        this.excludeNode = excludeNode;
    }

    public boolean isExcludeComments() {
        return this.excludeComments;
    }

    public void setExcludeComments(boolean excludeComments) {
        this.excludeComments = excludeComments;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public void setSourceURI(String sourceURI) {
        this.sourceURI = sourceURI;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public void setMIMEType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isNeedsToBeExpanded() {
        return this.needsToBeExpanded;
    }

    public void setNeedsToBeExpanded(boolean needsToBeExpanded) {
        this.needsToBeExpanded = needsToBeExpanded;
    }

    public boolean isSecureValidation() {
        return this.secureValidation;
    }

    public void setSecureValidation(boolean secureValidation) {
        this.secureValidation = secureValidation;
    }

    public boolean isOutputStreamSet() {
        return this.outputStream != null;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        if (this.isNodeSet()) {
            return className + "/NodeSet/" + this.inputNodeSet.size() + " nodes/" + this.getSourceURI();
        }
        if (this.isElement()) {
            return className + "/Element/" + this.subNode + " exclude " + this.excludeNode + " comments:" + this.excludeComments + "/" + this.getSourceURI();
        }
        if (this.hasUnprocessedInput()) {
            try {
                int available = this.getUnprocessedInput().available();
                return className + "/OctetStream/" + available + " bytes/" + this.getSourceURI();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return className + "/OctetStream//" + this.getSourceURI();
    }

    protected void canonicalize(OutputStream output, boolean c14n11) throws CanonicalizationException, IOException {
        Canonicalizer20010315 c14nizer = c14n11 ? new Canonicalizer11_OmitComments() : new Canonicalizer20010315OmitComments();
        c14nizer.engineCanonicalize(this, output, this.isSecureValidation());
        output.flush();
    }
}

