/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.shindig.auth.BasicSecurityTokenDecoder;
import org.apache.shindig.auth.BlobCrypterSecurityTokenDecoder;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.ContainerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultSecurityTokenDecoder
implements SecurityTokenDecoder {
    private static final String SECURITY_TOKEN_TYPE = "gadgets.securityTokenType";
    private final SecurityTokenDecoder decoder;

    @Inject
    public DefaultSecurityTokenDecoder(ContainerConfig config) {
        String tokenType = config.get("default", SECURITY_TOKEN_TYPE);
        if ("insecure".equals(tokenType)) {
            this.decoder = new BasicSecurityTokenDecoder();
        } else if ("secure".equals(tokenType)) {
            this.decoder = new BlobCrypterSecurityTokenDecoder(config);
        } else {
            throw new RuntimeException("Unknown security token type specified in default container configuration. gadgets.securityTokenType: " + tokenType);
        }
    }

    @Override
    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        return this.decoder.createToken(tokenParameters);
    }
}

