/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.Date;
import java.util.Locale;
import org.apache.shindig.common.util.DateUtil;
import org.junit.Assert;
import org.junit.Test;

public class DateUtilTest {
    String[] text = new String[]{"Tue, 27 May 2008 05:12:50 GMT", "Wed, 28 May 2008 04:40:48 GMT", "Mon, 30 Jun 3090 03:29:55 GMT", "Fri, 06 Jun 1670 01:57:27 GMT"};
    Date[] timeStamps = new Date[]{new Date(1211865170000L), new Date(1211949648000L), new Date(35359385395000L), new Date(-9453535353000L)};

    @Test
    public void parse() {
        int j = this.text.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((long)this.timeStamps[i].getTime(), (long)DateUtil.parseDate((String)this.text[i]).getTime());
        }
    }

    @Test
    public void format() {
        int j = this.timeStamps.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((Object)this.text[i], (Object)DateUtil.formatDate((long)this.timeStamps[i].getTime()));
        }
    }

    @Test
    public void formatDate() {
        int j = this.timeStamps.length;
        for (int i = 0; i < j; ++i) {
            Assert.assertEquals((Object)this.text[i], (Object)DateUtil.formatDate((Date)this.timeStamps[i]));
        }
    }

    @Test
    public void parseMalformed() {
        Assert.assertNull((Object)DateUtil.parseDate((String)"Invalid date format"));
    }

    @Test
    public void parseWrongTimeZone() {
        String expires = "Mon, 12 May 2008 09:23:29 PDT";
        Assert.assertNull((Object)DateUtil.parseDate((String)expires));
    }

    @Test
    public void parseRfc1036() {
        String expires = "Sunday, 06-Nov-94 08:49:37 GMT";
        Assert.assertNull((Object)DateUtil.parseDate((String)expires));
    }

    @Test
    public void parseAsctime() {
        String expires = "Sun Nov  6 08:49:37 1994";
        Assert.assertNull((Object)DateUtil.parseDate((String)expires));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void formatInWrongLocale() {
        Locale orig = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ITALY);
            this.formatDate();
        }
        finally {
            Locale.setDefault(orig);
        }
    }
}

