/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.uri;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.junit.Assert;
import org.junit.Test;

public class UriBuilderTest {
    @Test
    public void allPartsUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noSchemeUsed() {
        UriBuilder builder = new UriBuilder().setAuthority("apache.org").setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"//apache.org/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noAuthorityUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"http:/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noPathUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noQueryUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig#foo", (Object)builder.toString());
    }

    @Test
    public void noFragmentUsed() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setQuery("hello=world");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world", (Object)builder.toString());
    }

    @Test
    public void hostRelativePaths() {
        UriBuilder builder = new UriBuilder().setPath("/shindig").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void relativePaths() {
        UriBuilder builder = new UriBuilder().setPath("foo").setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"foo?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void noPathNoHostNoAuthority() {
        UriBuilder builder = new UriBuilder().setQuery("hello=world").setFragment("foo");
        Assert.assertEquals((Object)"?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void justSchemeAndAuthority() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org");
        Assert.assertEquals((Object)"http://apache.org", (Object)builder.toString());
    }

    @Test
    public void justPath() {
        UriBuilder builder = new UriBuilder().setPath("/shindig");
        Assert.assertEquals((Object)"/shindig", (Object)builder.toString());
    }

    @Test
    public void justAuthorityAndPath() {
        UriBuilder builder = new UriBuilder().setAuthority("apache.org").setPath("/shindig");
        Assert.assertEquals((Object)"//apache.org/shindig", (Object)builder.toString());
    }

    @Test
    public void justQuery() {
        UriBuilder builder = new UriBuilder().setQuery("hello=world");
        Assert.assertEquals((Object)"?hello=world", (Object)builder.toString());
    }

    @Test
    public void justFragment() {
        UriBuilder builder = new UriBuilder().setFragment("foo");
        Assert.assertEquals((Object)"#foo", (Object)builder.toString());
    }

    @Test
    public void addSingleQueryParameter() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello", "world").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void addTwoQueryParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello", "world").addQueryParameter("foo", "bar").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world&foo=bar#foo", (Object)builder.toString());
    }

    @Test
    public void addIdenticalParameters() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello", "world").addQueryParameter("hello", "goodbye").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello=world&hello=goodbye#foo", (Object)builder.toString());
    }

    @Test
    public void addBatchParameters() {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("foo", "bar");
        params.put("hello", "world");
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameters((Map)params).setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?foo=bar&hello=world#foo", (Object)builder.toString());
    }

    @Test
    public void queryStringIsUnescaped() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").setQuery("hello+world=world%26bar");
        Assert.assertEquals((Object)"world&bar", (Object)builder.getQueryParameter("hello world"));
    }

    @Test
    public void queryParamsAreEscaped() {
        UriBuilder builder = new UriBuilder().setScheme("http").setAuthority("apache.org").setPath("/shindig").addQueryParameter("hello world", "foo&bar").setFragment("foo");
        Assert.assertEquals((Object)"http://apache.org/shindig?hello+world=foo%26bar#foo", (Object)builder.toString());
        Assert.assertEquals((Object)"hello+world=foo%26bar", (Object)builder.getQuery());
    }

    @Test
    public void parse() {
        UriBuilder builder = UriBuilder.parse((String)"http://apache.org/shindig?foo=bar%26baz&foo=three#blah");
        Assert.assertEquals((Object)"http", (Object)builder.getScheme());
        Assert.assertEquals((Object)"apache.org", (Object)builder.getAuthority());
        Assert.assertEquals((Object)"/shindig", (Object)builder.getPath());
        Assert.assertEquals((Object)"foo=bar%26baz&foo=three", (Object)builder.getQuery());
        Assert.assertEquals((Object)"blah", (Object)builder.getFragment());
        Assert.assertEquals((Object)"bar&baz", (Object)builder.getQueryParameter("foo"));
        List<String> values = Arrays.asList("bar&baz", "three");
        Assert.assertEquals(values, (Object)builder.getQueryParameters("foo"));
    }

    @Test
    public void constructFromUriAndBack() {
        Uri uri = Uri.parse((String)"http://apache.org/foo/bar?foo=bar#foo");
        UriBuilder builder = new UriBuilder(uri);
        Assert.assertEquals((Object)uri, (Object)builder.toUri());
    }

    @Test
    public void constructFromUriAndModify() {
        Uri uri = Uri.parse((String)"http://apache.org/foo/bar?foo=bar#foo");
        UriBuilder builder = new UriBuilder(uri);
        builder.setAuthority("example.org");
        builder.addQueryParameter("bar", "foo");
        Assert.assertEquals((Object)"http://example.org/foo/bar?foo=bar&bar=foo#foo", (Object)builder.toString());
    }

    @Test
    public void equalsAndHashCodeOk() {
        UriBuilder uri = UriBuilder.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo");
        Map params = UriBuilder.splitParameters((String)"blah=blah");
        UriBuilder uri2 = new UriBuilder(Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo"));
        Assert.assertTrue((boolean)uri.equals((Object)uri2));
        Assert.assertTrue((boolean)uri2.equals((Object)uri));
        Assert.assertTrue((boolean)uri.equals((Object)uri));
        Assert.assertFalse((boolean)uri.equals(null));
        Assert.assertFalse((boolean)uri.equals((Object)"http://example.org/foo/bar/baz?blah=blah#boo"));
        Assert.assertFalse((boolean)uri.equals((Object)Uri.parse((String)"http://example.org/foo/bar/baz?blah=blah#boo")));
        Assert.assertTrue((uri.hashCode() == uri2.hashCode() ? 1 : 0) != 0);
    }
}

