/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.shindig.common.util.ImmediateFuture;

public class ImmediateFutureTest
extends TestCase {
    public void testGet() throws Exception {
        ImmediateFutureTest.assertEquals((String)"foo", (String)((String)ImmediateFuture.newInstance((Object)"foo").get()));
    }

    public void testGetNull() throws Exception {
        ImmediateFutureTest.assertNull(ImmediateFuture.newInstance(null).get());
    }

    public void testGetWithTimeout() throws Exception {
        ImmediateFutureTest.assertEquals((String)"foo", (String)((String)ImmediateFuture.newInstance((Object)"foo").get(1L, TimeUnit.MILLISECONDS)));
    }

    public void testCancel() {
        Future stringFuture = ImmediateFuture.newInstance((Object)"foo");
        ImmediateFutureTest.assertFalse((boolean)stringFuture.cancel(true));
        ImmediateFutureTest.assertFalse((boolean)stringFuture.cancel(false));
        ImmediateFutureTest.assertFalse((boolean)stringFuture.isCancelled());
    }

    public void testIsDone() {
        ImmediateFutureTest.assertTrue((boolean)ImmediateFuture.newInstance((Object)"foo").isDone());
    }

    public void testErrorInstance() throws Exception {
        RuntimeException re = new RuntimeException();
        Future errorFuture = ImmediateFuture.errorInstance((Throwable)re);
        try {
            errorFuture.get();
            ImmediateFutureTest.fail();
        }
        catch (ExecutionException ee) {
            ImmediateFutureTest.assertSame((Object)re, (Object)ee.getCause());
        }
    }
}

