/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.common.util.JsonConversionUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonConversionUtilTest
extends TestCase {
    public void testSimplePathToJsonParsing() throws Exception {
        JSONObject root = new JSONObject();
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a.a".split("\\."), (int)0);
        this.assertJsonEquals(root, new JSONObject("{a:{a:{}}}"));
    }

    public void testArrayPathToJsonParsing() throws Exception {
        JSONObject root = new JSONObject();
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a(0).a".split("\\."), (int)0);
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a(1).a".split("\\."), (int)0);
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a(2).a".split("\\."), (int)0);
        this.assertJsonEquals(root, new JSONObject("{a:{a:[{},{},{}]}}"));
    }

    public void testValueToJsonParsing() throws Exception {
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"abc"), "abc");
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"\"a,b,c\""), "a,b,c");
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"true"), true);
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"false"), false);
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"null"), JSONObject.NULL);
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"'abc'"), "abc");
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"a,b,c"), new JSONArray((Collection)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})));
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"1,2,3,true,false,null"), new JSONArray((Collection)Lists.newArrayList((Object[])new Serializable[]{Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Boolean.valueOf(true), Boolean.valueOf(false), null})));
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"(1)"), new JSONArray((Collection)Lists.newArrayList((Object[])new Integer[]{1})));
        this.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"(true)"), new JSONArray((Collection)Lists.newArrayList((Object[])new Boolean[]{true})));
    }

    public void testParameterMapToJsonParsing() throws Exception {
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"1")), new JSONObject("{a:{b:{c:1}}}"));
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"\"1\"")), new JSONObject("{a:{b:{c:\"1\"}}}"));
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"true")), new JSONObject("{a:{b:{c:true}}}"));
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"false")), new JSONObject("{a:{b:{c:false}}}"));
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"null")), new JSONObject("{a:{b:{c:null}}}"));
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b(0).c", (Object)"hello", (Object)"a.b(1).c", (Object)"hello")), new JSONObject("{a:{b:[{c:\"hello\"},{c:\"hello\"}]}}"));
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"hello, true, false, null, 1,2, \"null\", \"()\"")), new JSONObject("{a:{b:{c:[\"hello\",true,false,null,1,2,\"null\",\"()\"]}}}"));
        this.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"\"hello, true, false, null, 1,2\"")), new JSONObject("{a:{b:{c:\"hello, true, false, null, 1,2\"}}}"));
    }

    public void testJSONToParameterMapParsing() throws Exception {
        Map resultMap = JsonConversionUtil.fromJson((JSONObject)new JSONObject("{a:{b:[{c:\"hello\"},{c:\"hello\"}]}}"));
    }

    private void assertJsonEquals(Object expected, Object actual) throws JSONException {
        if (expected == null) {
            JsonConversionUtilTest.assertNull((Object)actual);
            return;
        }
        JsonConversionUtilTest.assertNotNull((Object)actual);
        if (expected instanceof JSONObject) {
            JSONObject expectedObject = (JSONObject)expected;
            JSONObject actualObject = (JSONObject)actual;
            if (expectedObject.length() == 0) {
                JsonConversionUtilTest.assertEquals((int)expectedObject.length(), (int)actualObject.length());
                return;
            }
            JsonConversionUtilTest.assertEquals((int)expectedObject.names().length(), (int)actualObject.names().length());
            Iterator keys = expectedObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JsonConversionUtilTest.assertTrue((boolean)actualObject.has(key));
                this.assertJsonEquals(expectedObject.get(key), actualObject.get(key));
            }
        } else if (expected instanceof JSONArray) {
            JSONArray expectedArray = (JSONArray)expected;
            JSONArray actualArray = (JSONArray)actual;
            JsonConversionUtilTest.assertEquals((int)expectedArray.length(), (int)actualArray.length());
            for (int i = 0; i < expectedArray.length(); ++i) {
                if (expectedArray.isNull(i)) {
                    JsonConversionUtilTest.assertTrue((boolean)actualArray.isNull(i));
                    continue;
                }
                this.assertJsonEquals(expectedArray.get(i), actualArray.get(i));
            }
        } else {
            JsonConversionUtilTest.assertEquals((Object)expected, (Object)actual);
        }
    }
}

