/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.xml;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomUtilTest {
    private static final String XML = "<root>  <other>whatever</other>  <element>zero</element>  <ElEmEnT>one</ElEmEnT>  <element>two</element>  <other>not real</other></root>";
    private static Element root;

    @BeforeClass
    public static void createRoot() throws XmlException {
        root = XmlUtil.parse((String)XML);
    }

    @Test
    public void getFirstNamedChildNode() {
        Assert.assertEquals((Object)"zero", (Object)DomUtil.getFirstNamedChildNode((Node)root, (String)"element").getTextContent());
        Assert.assertEquals((Object)"whatever", (Object)DomUtil.getFirstNamedChildNode((Node)root, (String)"other").getTextContent());
        Assert.assertNull((String)"Did not return null for missing element.", (Object)DomUtil.getFirstNamedChildNode((Node)root, (String)"fake"));
    }

    @Test
    public void getLastNamedChildNode() {
        Assert.assertEquals((Object)"two", (Object)DomUtil.getLastNamedChildNode((Node)root, (String)"element").getTextContent());
        Assert.assertEquals((Object)"not real", (Object)DomUtil.getLastNamedChildNode((Node)root, (String)"other").getTextContent());
        Assert.assertNull((String)"Did not return null for missing element.", (Object)DomUtil.getLastNamedChildNode((Node)root, (String)"fake"));
    }

    @Test
    public void getElementsByTagNameCaseInsensitive() {
        Document doc = root.getOwnerDocument();
        List elements = DomUtil.getElementsByTagNameCaseInsensitive((Document)doc, (Set)ImmutableSet.of((Object)"element"));
        Assert.assertEquals((Object)"zero", (Object)((Element)elements.get(0)).getTextContent());
        Assert.assertEquals((Object)"one", (Object)((Element)elements.get(1)).getTextContent());
        Assert.assertEquals((Object)"two", (Object)((Element)elements.get(2)).getTextContent());
    }
}

