/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import java.util.EnumSet;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;

public class BasicSecurityToken
extends AbstractSecurityToken {
    private static final EnumSet<AbstractSecurityToken.Keys> SUPPORTED = EnumSet.noneOf(AbstractSecurityToken.Keys.class);

    public BasicSecurityToken(String owner, String viewer, String app, String domain, String appUrl, String moduleId, String container, String activeUrl, Long expiresAt) {
        this.setOwnerId(owner).setViewerId(viewer).setAppId(app).setDomain(domain).setAppUrl(appUrl);
        if (moduleId != null) {
            this.setModuleId(Long.parseLong(moduleId));
        }
        this.setContainer(container).setActiveUrl(activeUrl).setExpiresAt(expiresAt);
    }

    public BasicSecurityToken() {
    }

    @Override
    public String getUpdatedToken() {
        return null;
    }

    @Override
    public String getAuthenticationMode() {
        return AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    protected EnumSet<AbstractSecurityToken.Keys> getMapKeys() {
        return SUPPORTED;
    }
}

