/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.base.Objects;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.shindig.common.util.VersionComparator;

public class OpenSocialVersion {
    public static Comparator<OpenSocialVersion> COMPARATOR = new VersionComparator();
    public int major = -1;
    public int minor = -1;
    public int patch = -1;

    public OpenSocialVersion(String versionString) {
        StringTokenizer tokens = new StringTokenizer(versionString, ".");
        try {
            if (tokens.hasMoreTokens()) {
                this.major = Integer.parseInt(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                this.minor = Integer.parseInt(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                this.patch = Integer.parseInt(tokens.nextToken());
            }
        }
        catch (NumberFormatException ex) {
            this.major = -1;
            this.minor = -1;
            this.patch = -1;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof OpenSocialVersion) {
            OpenSocialVersion ver = (OpenSocialVersion)o;
            return ver.major == this.major && ver.minor == this.minor && ver.patch == this.patch;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.major, this.minor, this.patch});
    }

    public boolean isEquivalent(OpenSocialVersion version) {
        int cmp = version.major - this.major;
        if (cmp == 0 && version.minor > -1 && this.minor > -1) {
            cmp = version.minor - this.minor;
        }
        if (cmp == 0 && version.patch > -1 && this.patch > -1) {
            cmp = version.patch - this.patch;
        }
        return cmp == 0;
    }

    public boolean isEquivalent(String version) {
        return this.isEquivalent(new OpenSocialVersion(version));
    }

    public boolean isEqualOrGreaterThan(OpenSocialVersion version) {
        int cmp = version.major - this.major;
        if (cmp == 0) {
            cmp = version.minor > -1 && this.minor > -1 ? version.minor - this.minor : version.minor;
        }
        if (cmp == 0) {
            cmp = version.patch > -1 && this.patch > -1 ? version.patch - this.patch : version.patch;
        }
        return cmp <= 0;
    }

    public boolean isEqualOrGreaterThan(String version) {
        return this.isEqualOrGreaterThan(new OpenSocialVersion(version));
    }
}

