/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public final class ResourceLoader {
    public static final String RESOURCE_PREFIX = "res://";
    public static final String FILE_PREFIX = "file://";

    private ResourceLoader() {
    }

    public static InputStream open(String path) throws IOException {
        if (path.startsWith(RESOURCE_PREFIX)) {
            return ResourceLoader.openResource(path.substring(RESOURCE_PREFIX.length()));
        }
        if (path.startsWith(FILE_PREFIX)) {
            path = path.substring(FILE_PREFIX.length());
        }
        File file = new File(path);
        return new FileInputStream(file);
    }

    public static InputStream openResource(String resource) throws FileNotFoundException {
        ClassLoader cl = ResourceLoader.class.getClassLoader();
        try {
            return ResourceLoader.openResource(cl, resource);
        }
        catch (FileNotFoundException e) {
            cl = Thread.currentThread().getContextClassLoader();
            return ResourceLoader.openResource(cl, resource);
        }
    }

    private static InputStream openResource(ClassLoader cl, String resource) throws FileNotFoundException {
        InputStream is = cl.getResourceAsStream(resource.trim());
        if (is == null) {
            throw new FileNotFoundException("Can not locate resource: " + resource);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String resource) throws IOException {
        InputStream is = ResourceLoader.openResource(resource);
        try {
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

