/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.crypto;

import java.security.GeneralSecurityException;
import java.util.regex.Pattern;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.util.FakeTimeSource;
import org.junit.Assert;

public class CryptoTest {
    private BasicBlobCrypter crypter = new BasicBlobCrypter("0123456789abcdef".getBytes());

    public static Test suite() {
        return new JUnit4TestAdapter(CryptoTest.class);
    }

    public CryptoTest() {
        this.crypter.timeSource = new FakeTimeSource();
    }

    @org.junit.Test
    public void testHmacSha1() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-21, 2, 47, -101, 9, -40, 18, 43, 76, 117, -51, 115, -122, -91, 39, 26, -18, 122, 30, 90};
        byte[] hmac = Crypto.hmacSha1((byte[])key.getBytes(), (byte[])val.getBytes());
        Assert.assertArrayEquals((byte[])expected, (byte[])hmac);
    }

    @org.junit.Test
    public void testHmacSha1Verify() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-21, 2, 47, -101, 9, -40, 18, 43, 76, 117, -51, 115, -122, -91, 39, 26, -18, 122, 30, 90};
        Crypto.hmacSha1Verify((byte[])key.getBytes(), (byte[])val.getBytes(), (byte[])expected);
    }

    @org.junit.Test
    public void testHmacSha1VerifyTampered() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-21, 2, 47, -101, 9, -40, 18, 43, 76, 117, -51, 115, -122, -91, 39, 0, -18, 122, 30, 90};
        try {
            Crypto.hmacSha1Verify((byte[])key.getBytes(), (byte[])val.getBytes(), (byte[])expected);
            Assert.fail();
        }
        catch (GeneralSecurityException e) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testAes128Cbc() throws Exception {
        byte[] key = Crypto.getRandomBytes((int)16);
        for (int i = 0; i < 50; i = (int)((byte)(i + 1))) {
            byte[] orig = new byte[i];
            for (int j = 0; j < i; j = (int)((byte)(j + 1))) {
                orig[j] = j;
            }
            byte[] cipherText = Crypto.aes128cbcEncrypt((byte[])key, (byte[])orig);
            byte[] plainText = Crypto.aes128cbcDecrypt((byte[])key, (byte[])cipherText);
            Assert.assertArrayEquals((String)("Array of length " + i), (byte[])orig, (byte[])plainText);
        }
    }

    @org.junit.Test
    public void testRandomDigits() throws Exception {
        Pattern digitPattern = Pattern.compile("^\\d+$");
        String digits = Crypto.getRandomDigits((int)100);
        Assert.assertEquals((long)100L, (long)digits.length());
        Assert.assertTrue((String)("Should be only digits: " + digits), (boolean)digitPattern.matcher(digits).matches());
    }
}

