/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import junit.framework.TestCase;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.Functions;
import org.apache.shindig.expressions.ShindigTypeConverter;
import org.json.JSONObject;

public class FunctionsTest
extends TestCase {
    private Functions functions;

    protected void setUp() throws Exception {
        this.functions = new Functions(new Class[]{FunctionsTest.class});
    }

    public void testExpose() throws Exception {
        Method hi = this.functions.resolveFunction("test", "hi");
        FunctionsTest.assertEquals((Object)"hi", (Object)hi.invoke(null, new Object[0]));
        Method hiAlternate = this.functions.resolveFunction("test", "hola");
        FunctionsTest.assertEquals((Object)"hi", (Object)hiAlternate.invoke(null, new Object[0]));
        Method bonjour = this.functions.resolveFunction("other", "bonjour");
        FunctionsTest.assertEquals((Object)"French hello", (Object)bonjour.invoke(null, new Object[0]));
    }

    public void testNonStaticNotExposed() {
        FunctionsTest.assertNull((Object)this.functions.resolveFunction("test", "goodbye"));
    }

    public void testDefaultBinding() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        this.functions = (Functions)injector.getInstance(Functions.class);
        Method toJson = this.functions.resolveFunction("osx", "parseJson");
        Object o = toJson.invoke(null, "{a : 1}");
        FunctionsTest.assertTrue((boolean)(o instanceof JSONObject));
        FunctionsTest.assertEquals((int)1, (int)((JSONObject)o).getInt("a"));
    }

    public void testExpressionEvaluation() {
        Expressions expressions = new Expressions(this.functions, null, new ShindigTypeConverter());
        ELContext context = expressions.newELContext(new ELResolver[0]);
        ValueExpression expression = expressions.parse("${other:bonjour()}", String.class);
        FunctionsTest.assertEquals((Object)"French hello", (Object)expression.getValue(context));
        expression = expressions.parse("${test:add(1, 2)}", Integer.class);
        FunctionsTest.assertEquals((Object)3, (Object)expression.getValue(context));
    }

    @Functions.Expose(prefix="test", names={"hi", "hola"})
    public static String sayHi() {
        return "hi";
    }

    @Functions.Expose(prefix="test", names={"add"})
    public static int add(int i, int j) {
        return i + j;
    }

    @Functions.Expose(prefix="other", names={"bonjour"})
    public static String sayHi2() {
        return "French hello";
    }

    @Functions.Expose(prefix="test", names={"goodbye"})
    public String sayGoodbye() {
        return "goodbye";
    }
}

