/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RpcHandler;
import org.apache.shindig.protocol.TestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.json.JSONObject;
import org.junit.Assert;

public class DefaultHandlerRegistryTest
extends TestCase {
    private DefaultHandlerRegistry registry;
    private BeanJsonConverter converter;

    protected void setUp() throws Exception {
        super.setUp();
        this.converter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[0]));
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)Sets.newHashSet((Object[])new Object[]{new TestHandler()}));
    }

    public void testGetHandlerRPC() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRpcHandler(new JSONObject("{method : test.get}")));
    }

    public void testGetHandlerRest() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRestHandler("/test/", "GET"));
    }

    public void testOverrideHandlerRPC() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRpcHandler(new JSONObject("{method : test.overidden}")));
    }

    public void testOverrideHandlerRPCName() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRpcHandler(new JSONObject("{method : test.override.rpcname}")));
    }

    public void testOverrideHandlerRest() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRestHandler("/test/overidden/method/", "GET"));
    }

    public void testGetForAliasHandler() {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRestHandler("/test", "GET"));
    }

    public void testRpcHandler_serviceDoesntExist() throws Exception {
        JSONObject rpc = new JSONObject("{method : makebelieve.get}");
        RpcHandler rpcHandler = this.registry.getRpcHandler(rpc);
        try {
            Future future = rpcHandler.execute(null, null, null);
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Expect exception for missing method");
        }
        catch (ExecutionException t) {
            DefaultHandlerRegistryTest.assertSame(t.getCause().getClass(), ProtocolException.class);
            junit.framework.Assert.assertEquals((int)((ProtocolException)t.getCause()).getCode(), (int)501);
        }
        catch (Throwable t) {
            DefaultHandlerRegistryTest.fail((String)("Unexpected exception " + t.toString()));
        }
    }

    public void testRestHandler_serviceDoesntExist() {
        RestHandler restHandler = this.registry.getRestHandler("/makebelieve", "GET");
        try {
            Future future = restHandler.execute((Map)Maps.newHashMap(), null, null, null);
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Expect exception for missing method");
        }
        catch (ExecutionException t) {
            DefaultHandlerRegistryTest.assertSame(t.getCause().getClass(), ProtocolException.class);
            junit.framework.Assert.assertEquals((int)((ProtocolException)t.getCause()).getCode(), (int)501);
        }
        catch (Throwable t) {
            DefaultHandlerRegistryTest.fail((String)("Unexpected exception " + t.toString()));
        }
    }

    public void testNonFutureDispatch() throws Exception {
        RestHandler handler = this.registry.getRestHandler("/test", "GET");
        Future future = handler.execute((Map)Maps.newHashMap(), null, null, null);
        DefaultHandlerRegistryTest.assertEquals(future.get(), (Object)"GET_RESPONSE");
    }

    public void testFutureDispatch() throws Exception {
        RestHandler handler = this.registry.getRestHandler("/test", "POST");
        Future future = handler.execute((Map)Maps.newHashMap(), null, null, null);
        DefaultHandlerRegistryTest.assertEquals(future.get(), (Object)"CREATE_RESPONSE");
    }

    public void testRpcWithInputClassThatIsntRequestItem() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.echo, params: {value: 'Bob' }}");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, (BeanConverter)this.converter);
        DefaultHandlerRegistryTest.assertEquals(future.get(), (Object)"ECHO: Bob");
    }

    public void testRestWithInputClassThatIsntRequestItem() throws Exception {
        RestHandler handler = this.registry.getRestHandler("/test/echo", "GET");
        String[] value = new String[]{"Bob"};
        Future future = handler.execute((Map)ImmutableMap.of((Object)"value", (Object)value), null, null, (BeanConverter)this.converter);
        DefaultHandlerRegistryTest.assertEquals(future.get(), (Object)"ECHO: Bob");
    }

    public void testNoArgumentClass() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.noArg }");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, (BeanConverter)this.converter);
        DefaultHandlerRegistryTest.assertEquals(future.get(), (Object)"No arguments from me!");
    }

    public void testNonFutureException() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.exception }");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, null);
        try {
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Service method did not produce NullPointerException from Future");
        }
        catch (ExecutionException ee) {
            DefaultHandlerRegistryTest.assertSame(ee.getCause().getClass(), NullPointerException.class);
        }
    }

    public void testFutureException() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.futureException }");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, null);
        try {
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Service method did not produce ExecutionException from Future");
        }
        catch (ExecutionException ee) {
            DefaultHandlerRegistryTest.assertSame(ee.getCause().getClass(), ProtocolException.class);
        }
    }

    public void testSupportedRpcServices() throws Exception {
        DefaultHandlerRegistryTest.assertEquals((Object)this.registry.getSupportedRpcServices(), (Object)Sets.newHashSet((Object[])new String[]{"test.create", "test.get", "test.overridden", "test.exception", "test.futureException", "test.override.rpcname", "test.echo", "test.noArg"}));
    }

    public void testSupportedRestServices() throws Exception {
        DefaultHandlerRegistryTest.assertEquals((Object)this.registry.getSupportedRestServices(), (Object)Sets.newHashSet((Object[])new String[]{"GET /test/{someParam}/{someOtherParam}", "PUT /test/{someParam}/{someOtherParam}", "DELETE /test/{someParam}/{someOtherParam}", "POST /test/{someParam}/{someOtherParam}", "GET /test/overridden/method", "GET /test/echo"}));
    }

    public void testAddNonService() {
        try {
            this.registry.addHandlers((Set)Sets.newHashSet((Object[])new Object[]{new Object()}));
            DefaultHandlerRegistryTest.fail((String)"Adding an invalid service object succeded");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRestPath() {
        DefaultHandlerRegistry.RestPath restPath = new DefaultHandlerRegistry.RestPath("/service/const1/{p1}/{p2}+/const2/{p3}", null);
        DefaultHandlerRegistry.RestInvocationWrapper wrapper = restPath.accept("service/const1/a/b,c/const2/d".split("/"));
        Assert.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p1")), (Object[])new String[]{"a"});
        Assert.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p2")), (Object[])new String[]{"b", "c"});
        Assert.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p3")), (Object[])new String[]{"d"});
        wrapper = restPath.accept("service/const1/a/b/const2".split("/"));
        Assert.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p1")), (Object[])new String[]{"a"});
        Assert.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p2")), (Object[])new String[]{"b"});
        DefaultHandlerRegistryTest.assertNull(wrapper.pathParams.get("p3"));
        DefaultHandlerRegistryTest.assertNull((Object)restPath.accept("service/const1/{p1}/{p2}+".split("/")));
        DefaultHandlerRegistryTest.assertNull((Object)restPath.accept("service/constmiss/{p1}/{p2}+/const2".split("/")));
    }

    public void testRestPathOrdering() {
        DefaultHandlerRegistry.RestPath restPath1 = new DefaultHandlerRegistry.RestPath("/service/const1/{p1}/{p2}+/const2/{p3}", null);
        DefaultHandlerRegistry.RestPath restPath2 = new DefaultHandlerRegistry.RestPath("/service/{p1}/{p2}+/const2/{p3}", null);
        DefaultHandlerRegistry.RestPath restPath3 = new DefaultHandlerRegistry.RestPath("/service/const1/const2/{p1}/{p2}+/{p3}", null);
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of((Comparable[])new DefaultHandlerRegistry.RestPath[]{restPath1, restPath2, restPath3});
        Iterator itr = sortedSet.iterator();
        DefaultHandlerRegistryTest.assertEquals(itr.next(), (Object)restPath3);
        DefaultHandlerRegistryTest.assertEquals(itr.next(), (Object)restPath1);
        DefaultHandlerRegistryTest.assertEquals(itr.next(), (Object)restPath2);
    }
}

