/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.jsonlib;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.shindig.protocol.conversion.jsonlib.ApiValidator;
import org.apache.shindig.protocol.conversion.jsonlib.ApiValidatorException;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ApiValidatorTest {
    private static final String TEST_DEFINITION = "var TestDef = {}; TestDef.Field = { FIELD1 : \"json\", FIELD2 : \"xyz\", FIELD3 : \"shouldBeMissing\" };";
    private static final String[] TEST_DEFINITION_FIELDS = new String[]{"json", "xyz", "shouldBeMissing"};

    @Test
    public void testValidator() throws ApiValidatorException, IOException, ParserConfigurationException, SAXException {
        ApiValidator apiVal = new ApiValidator();
        apiVal.addScript(TEST_DEFINITION);
        String[] optional = new String[]{"shouldBeMissing"};
        String[] nullfields = new String[]{};
        Map<String, Object> result = apiVal.validate("{ json: \"A Test JSON\", xyz : 123 }", "TestDef.Field", optional, nullfields);
        Assert.assertNotNull(result);
        Assert.assertNotNull((Object)result.get("json"));
        Assert.assertNotNull((Object)result.get("xyz"));
        Assert.assertSame(String.class, result.get("json").getClass());
        Assert.assertSame(Integer.class, result.get("xyz").getClass());
        Assert.assertEquals((Object)"A Test JSON", (Object)result.get("json"));
        Assert.assertEquals((long)123L, (long)((Integer)result.get("xyz")).intValue());
    }

    @Test
    public void testValidatorFail() throws ApiValidatorException, IOException, ParserConfigurationException, SAXException {
        ApiValidator apiVal = new ApiValidator();
        apiVal.addScript(TEST_DEFINITION);
        String[] optional = new String[]{};
        String[] nullfields = new String[]{};
        try {
            apiVal.validate("{ jsonIsMissing: \"A Test JSON\", xyz : 123 }", "TestDef.Field", optional, nullfields);
            Assert.fail((String)"Should have Generated an APIValidatorException ");
        }
        catch (ApiValidatorException ex) {
            // empty catch block
        }
    }

    @Test
    public void testFieldsValidator() throws ApiValidatorException, IOException, ParserConfigurationException, SAXException {
        ApiValidator apiVal = new ApiValidator();
        String[] optional = new String[]{"shouldBeMissing"};
        String[] nullfields = new String[]{};
        Map<String, Object> result = apiVal.validate("{ json: \"A Test JSON\", xyz : 123 }", TEST_DEFINITION_FIELDS, optional, nullfields);
        Assert.assertNotNull(result);
        Assert.assertNotNull((Object)result.get("json"));
        Assert.assertNotNull((Object)result.get("xyz"));
        Assert.assertSame(String.class, result.get("json").getClass());
        Assert.assertSame(Integer.class, result.get("xyz").getClass());
        Assert.assertEquals((Object)"A Test JSON", (Object)result.get("json"));
        Assert.assertEquals((long)123L, (long)((Integer)result.get("xyz")).intValue());
    }

    @Test
    public void testFieldsValidatorFail() throws ApiValidatorException, IOException, ParserConfigurationException, SAXException {
        ApiValidator apiVal = new ApiValidator();
        String[] optional = new String[]{};
        String[] nullfields = new String[]{};
        try {
            apiVal.validate("{ jsonIsMissing: \"A Test JSON\", xyz : 123 }", TEST_DEFINITION_FIELDS, optional, nullfields);
            Assert.fail((String)"Should have Generated an APIValidatorException ");
        }
        catch (ApiValidatorException ex) {
            // empty catch block
        }
    }
}

