/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.jsonlib;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.json.JsonConfig;
import net.sf.json.util.EnumMorpher;
import net.sf.json.util.JSONUtils;
import org.apache.shindig.protocol.conversion.jsonlib.BaseJsonLibConfig;
import org.apache.shindig.protocol.model.TestModel;

public class JsonLibTestsGuiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(Map.class).to(HashMap.class);
        this.bind(List.class).to(ArrayList.class);
        this.bind(JsonConfig.class).annotatedWith((Annotation)Names.named((String)"ShindigJsonConfig")).to(TestJsonLibConfig.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestJsonLibConfig
    extends BaseJsonLibConfig {
        @Inject
        public TestJsonLibConfig(Injector injector) {
            super(injector);
        }

        protected void registerMorphers() {
            super.registerMorphers();
            MorpherRegistry morpherRegistry = JSONUtils.getMorpherRegistry();
            morpherRegistry.registerMorpher((Morpher)new EnumMorpher(TestModel.Engine.class));
        }

        protected Map<String, Class<?>> createClassMap() {
            Map classMap = super.createClassMap();
            classMap.put("parkingTickets", Map.class);
            classMap.put("passengers", TestModel.Passenger.class);
            return classMap;
        }
    }
}

