/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.InjectedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationServletFilter
extends InjectedFilter {
    public static final String AUTH_TYPE_OAUTH = "OAuth";
    private List<AuthenticationHandler> handlers;

    @Inject
    public void setAuthenticationHandlers(List<AuthenticationHandler> handlers) {
        this.handlers = handlers;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Auth filter can only handle HTTP");
        }
        HttpServletRequest req = (HttpServletRequest)request;
        for (AuthenticationHandler handler : this.handlers) {
            SecurityToken token = handler.getSecurityTokenFromRequest(req);
            if (token == null) continue;
            new AuthInfo(req).setAuthType(handler.getName()).setSecurityToken(token);
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        chain.doFilter((ServletRequest)req, response);
    }
}

