/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.BasicSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BlobCrypterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BasicSecurityTokenDecoder
implements SecurityTokenDecoder {
    private static final int OWNER_INDEX = 0;
    private static final int VIEWER_INDEX = 1;
    private static final int APP_ID_INDEX = 2;
    private static final int CONTAINER_INDEX = 3;
    private static final int APP_URL_INDEX = 4;
    private static final int MODULE_ID_INDEX = 5;
    private static final int TOKEN_COUNT = 6;

    public String encodeToken(SecurityToken token) {
        try {
            StringBuilder out = new StringBuilder();
            out.append(URLEncoder.encode(token.getOwnerId(), "UTF-8")).append(':').append(URLEncoder.encode(token.getViewerId(), "UTF-8")).append(':').append(URLEncoder.encode(token.getAppId(), "UTF-8")).append(':').append(URLEncoder.encode(token.getDomain(), "UTF-8")).append(':').append(URLEncoder.encode(token.getAppUrl(), "UTF-8")).append(':').append(Long.toString(token.getModuleId()));
            return out.toString();
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
    }

    @Override
    public SecurityToken createToken(Map<String, String> parameters) throws SecurityTokenException {
        String token = parameters.get("token");
        if (token == null || token.trim().length() == 0) {
            return new AnonymousSecurityToken();
        }
        try {
            String[] tokens = token.split(":");
            if (tokens.length != 6) {
                throw new SecurityTokenException("Malformed security token");
            }
            return new BasicSecurityToken(URLDecoder.decode(tokens[0], "UTF-8"), URLDecoder.decode(tokens[1], "UTF-8"), URLDecoder.decode(tokens[2], "UTF-8"), URLDecoder.decode(tokens[3], "UTF-8"), URLDecoder.decode(tokens[4], "UTF-8"), URLDecoder.decode(tokens[5], "UTF-8"));
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityTokenException(e);
        }
    }
}

