/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.TimeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtlCache<K, V>
implements Cache<K, V> {
    private final Cache<K, TimeoutPair<V>> baseCache;
    private final long minTtl;
    private final long maxTtl;
    private TimeSource timeSource;
    private long defaultLifetime;
    private static final long DEFAULT_LIFETIME_MILLIS = 0L;

    public TtlCache(CacheProvider cacheProvider, int capacity, long minTtl, long maxTtl) {
        this.baseCache = cacheProvider.createCache(capacity);
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        this.timeSource = new TimeSource();
        this.defaultLifetime = 0L;
    }

    public void setDefaultLifetimeMillis(long defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    @Override
    public V getElement(K key) {
        CachedObject<V> cached = this.getElementMaybeRemove(key, false);
        if (!cached.isExpired) {
            return cached.obj;
        }
        return null;
    }

    public CachedObject<V> getElementWithExpiration(K key) {
        return this.getElementMaybeRemove(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(K key, V val, long expiration) {
        long now = this.timeSource.currentTimeMillis();
        long minAllowed = Math.min(now + this.maxTtl, expiration);
        if (now > 0L && this.maxTtl > 0L && minAllowed < 0L) {
            minAllowed = this.maxTtl;
        }
        expiration = Math.max(now + this.minTtl, minAllowed);
        TimeoutPair entry = new TimeoutPair(val, expiration);
        Cache<K, TimeoutPair<V>> cache = this.baseCache;
        synchronized (cache) {
            this.baseCache.addElement(key, entry);
        }
    }

    public void addElementWithTtl(K key, V val, long ttl) {
        this.addElement(key, val, System.currentTimeMillis() + ttl);
    }

    @Override
    public void addElement(K key, V val) {
        this.addElement(key, val, this.defaultLifetime);
    }

    @Override
    public V removeElement(K key) {
        CachedObject<V> cached = this.getElementMaybeRemove(key, true);
        if (!cached.isExpired) {
            return cached.obj;
        }
        return null;
    }

    void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    private CachedObject<V> getElementMaybeRemove(K key, boolean remove) {
        TimeoutPair<V> entry = null;
        entry = remove ? this.baseCache.removeElement(key) : this.baseCache.getElement(key);
        if (entry == null) {
            return new CachedObject(null, true);
        }
        long now = this.timeSource.currentTimeMillis();
        return new CachedObject(((TimeoutPair)entry).cachedObj, now >= ((TimeoutPair)entry).expiration);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CachedObject<V> {
        public V obj;
        public boolean isExpired;

        private CachedObject(V obj, boolean isExpired) {
            this.obj = obj;
            this.isExpired = isExpired;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TimeoutPair<V> {
        private V cachedObj;
        private long expiration;

        private TimeoutPair(V cachedObj, long expiration) {
            this.cachedObj = cachedObj;
            this.expiration = expiration;
        }
    }
}

