/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache.ehcache;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.management.ManagementService;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.ehcache.EhConfiguredCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheCacheProvider
implements CacheProvider {
    private CacheManager cacheManager;
    private Map<String, Cache<?, ?>> caches = new HashMap();

    public EhCacheCacheProvider() {
        this.create("/org/apache/shindig/common/cache/ehcache/ehcacheConfig.xml", "true");
    }

    @Inject
    public EhCacheCacheProvider(@Named(value="cache.config") String configPath, @Named(value="cache.jmx.stats") String withCacheStatistics) {
        this.create(configPath, withCacheStatistics);
    }

    public void create(String configPath, String withCacheStatistics) {
        URL url = this.getClass().getResource(configPath);
        this.cacheManager = new CacheManager(url);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    EhCacheCacheProvider.this.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ManagementService.registerMBeans((CacheManager)this.cacheManager, (MBeanServer)mBeanServer, (boolean)true, (boolean)true, (boolean)true, (boolean)Boolean.valueOf(withCacheStatistics));
    }

    public void shutdown() {
        this.cacheManager.shutdown();
    }

    @Override
    public <K, V> Cache<K, V> createCache(int capacity) {
        return this.createCache(capacity, null);
    }

    @Override
    public <K, V> Cache<K, V> createCache(int capacity, String name) {
        if (name == null) {
            return new EhConfiguredCache(capacity, name, this.cacheManager);
        }
        Cache<?, ?> c = this.caches.get(name);
        if (c == null) {
            c = new EhConfiguredCache(capacity, name, this.cacheManager);
            this.caches.put(name, c);
        }
        return c;
    }
}

