/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache.ehcache;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.ehcache.EhCacheCacheProvider;
import org.apache.shindig.common.util.ResourceLoader;

public class EhCacheGuiceCacheModule
extends AbstractModule {
    private final Properties properties;
    private static final String DEFAULT_PROPERTIES = "ehcache.properties";

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.properties);
        this.bind(CacheProvider.class).to(EhCacheCacheProvider.class).in(Scopes.SINGLETON);
    }

    public EhCacheGuiceCacheModule(Properties properties) {
        this.properties = properties;
    }

    public EhCacheGuiceCacheModule() {
        Properties properties = null;
        try {
            InputStream is = ResourceLoader.openResource(DEFAULT_PROPERTIES);
            properties = new Properties();
            properties.load(is);
        }
        catch (IOException e) {
            throw new CreationException(Arrays.asList(new Message("Unable to load properties: ehcache.properties")));
        }
        this.properties = properties;
    }
}

