/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    private static DateTimeFormatter rfc1123DateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);

    private DateUtil() {
    }

    public static Date parseDate(String dateStr) {
        try {
            return rfc1123DateFormat.parseDateTime(dateStr).toDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date.getTime());
    }

    public static String formatDate(long timeStamp) {
        return rfc1123DateFormat.print(timeStamp);
    }
}

