/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;

public class UrlParameterAuthenticationHandler
implements AuthenticationHandler {
    public static final String AUTH_URL_PARAMETER = "SecurityTokenUrlParameter";
    private static final Logger logger = Logger.getLogger(UrlParameterAuthenticationHandler.class.getName());
    private final SecurityTokenDecoder securityTokenDecoder;

    @Inject
    public UrlParameterAuthenticationHandler(SecurityTokenDecoder securityTokenDecoder) {
        this.securityTokenDecoder = securityTokenDecoder;
    }

    public String getName() {
        return AUTH_URL_PARAMETER;
    }

    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) {
        try {
            String token = request.getParameter("st");
            Map<String, String> parameters = Collections.singletonMap("token", token);
            return this.securityTokenDecoder.createToken(parameters);
        }
        catch (SecurityTokenException e) {
            logger.log(Level.INFO, "Valid security token not found.", e);
            return null;
        }
    }
}

