/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultCacheProvider
implements CacheProvider {
    private Map<String, Cache<?, ?>> cacheInstances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Cache<K, V> createCache(int capacity, String name) {
        if (name == null) {
            return new LruCache(capacity);
        }
        Map<String, Cache<?, ?>> map = this.cacheInstances;
        synchronized (map) {
            Cache<?, ?> c = this.cacheInstances.get(name);
            if (c == null) {
                c = new LruCache(capacity);
                this.cacheInstances.put(name, c);
            }
            return c;
        }
    }

    @Override
    public <K, V> Cache<K, V> createCache(int capacity) {
        return this.createCache(capacity, null);
    }
}

