/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shindig.common.cache.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCache<K, V>
extends LinkedHashMap<K, V>
implements Cache<K, V> {
    private final int capacity;

    @Override
    public V getElement(K key) {
        return super.get(key);
    }

    @Override
    public void addElement(K key, V value) {
        super.put(key, value);
    }

    @Override
    public V removeElement(K key) {
        return super.remove(key);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.capacity;
    }

    public static <K, V> LruCache<K, V> create(int capacity) {
        return new LruCache<K, V>(capacity);
    }

    public LruCache(int capacity) {
        super(capacity, 0.75f, true);
        this.capacity = capacity;
    }
}

