/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobExpiredException;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.util.FakeTimeSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobCrypterSecurityTokenTest {
    private static final String CONTAINER = "container";
    private static final String DOMAIN = "example.com";
    private FakeTimeSource timeSource = new FakeTimeSource();
    private BasicBlobCrypter crypter;

    @Before
    public void setUp() {
        this.crypter = new BasicBlobCrypter(Crypto.getRandomBytes((int)20));
        this.crypter.timeSource = this.timeSource;
    }

    @Test
    public void testNullValues() throws Exception {
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken((BlobCrypter)this.crypter, CONTAINER, DOMAIN);
        String token = t.encrypt();
        Assert.assertTrue((String)("should start with container: " + token), (boolean)token.startsWith("container:"));
        String[] fields = token.split(":");
        BlobCrypterSecurityToken t2 = BlobCrypterSecurityToken.decrypt((BlobCrypter)this.crypter, (String)CONTAINER, (String)DOMAIN, (String)fields[1], null);
        Assert.assertNull((String)t2.getAppId(), (Object)t2.getAppId());
        Assert.assertNull((String)t2.getAppUrl(), (Object)t2.getAppUrl());
        Assert.assertEquals((Object)DOMAIN, (Object)t2.getDomain());
        Assert.assertEquals((long)0L, (long)t2.getModuleId());
        Assert.assertNull((String)t2.getOwnerId(), (Object)t2.getOwnerId());
        Assert.assertNull((String)t2.getViewerId(), (Object)t2.getViewerId());
        Assert.assertNull((String)t2.getTrustedJson(), (Object)t2.getTrustedJson());
        Assert.assertNull((String)t2.getUpdatedToken(), (Object)t2.getUpdatedToken());
        Assert.assertEquals((Object)CONTAINER, (Object)t2.getContainer());
        try {
            t2.getActiveUrl();
            Assert.fail((String)"Should have thrown");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @Test
    public void testRealValues() throws Exception {
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken((BlobCrypter)this.crypter, CONTAINER, DOMAIN);
        t.setAppUrl("http://www.example.com/gadget.xml");
        t.setModuleId(12345L);
        t.setOwnerId("owner");
        t.setViewerId("viewer");
        t.setTrustedJson("trusted");
        String token = t.encrypt();
        Assert.assertTrue((String)("should start with container: " + token), (boolean)token.startsWith("container:"));
        String[] fields = token.split(":");
        BlobCrypterSecurityToken t2 = BlobCrypterSecurityToken.decrypt((BlobCrypter)this.crypter, (String)CONTAINER, (String)DOMAIN, (String)fields[1], (String)"active");
        Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppId());
        Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppUrl());
        Assert.assertEquals((Object)DOMAIN, (Object)t2.getDomain());
        Assert.assertEquals((long)12345L, (long)t2.getModuleId());
        Assert.assertEquals((Object)"owner", (Object)t2.getOwnerId());
        Assert.assertEquals((Object)"viewer", (Object)t2.getViewerId());
        Assert.assertEquals((Object)"trusted", (Object)t2.getTrustedJson());
        Assert.assertEquals((Object)CONTAINER, (Object)t2.getContainer());
        Assert.assertEquals((Object)"active", (Object)t2.getActiveUrl());
    }

    @Test
    public void testExpired() throws Exception {
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken((BlobCrypter)this.crypter, CONTAINER, DOMAIN);
        String token = t.encrypt();
        this.timeSource.incrementSeconds(3781);
        String[] fields = token.split(":");
        try {
            BlobCrypterSecurityToken.decrypt((BlobCrypter)this.crypter, (String)CONTAINER, (String)DOMAIN, (String)fields[1], (String)"active");
            Assert.fail((String)"Token should have expired");
        }
        catch (BlobExpiredException e) {
            // empty catch block
        }
    }
}

