/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.shindig.auth.DefaultSecurityTokenDecoder;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.config.AbstractContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.ContainerConfigException;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSecurityTokenDecoderTest {
    @Test
    public void testBasicDecoder() throws Exception {
        DefaultSecurityTokenDecoder decoder = new DefaultSecurityTokenDecoder((ContainerConfig)new FakeContainerConfig("insecure"));
        String token = "o:v:app:domain:appurl:12345:container";
        Map<String, String> parameters = Collections.singletonMap("token", token);
        SecurityToken st = decoder.createToken(parameters);
        Assert.assertEquals((Object)"o", (Object)st.getOwnerId());
        Assert.assertEquals((Object)"v", (Object)st.getViewerId());
        Assert.assertEquals((Object)"appurl", (Object)st.getAppUrl());
        Assert.assertEquals((Object)"container", (Object)st.getContainer());
    }

    @Test
    public void testInvalidDecoder() throws Exception {
        try {
            new DefaultSecurityTokenDecoder((ContainerConfig)new FakeContainerConfig("garbage"));
            Assert.fail((String)"Should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("exception should contain garbage: " + e), (boolean)e.getMessage().contains("garbage"));
        }
    }

    @Test
    public void testNullDecoder() throws Exception {
        try {
            new DefaultSecurityTokenDecoder((ContainerConfig)new FakeContainerConfig(null));
            Assert.fail((String)"Should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("exception should contain null: " + e), (boolean)e.getMessage().contains("null"));
        }
    }

    @Test
    public void testRealDecoder() throws Exception {
        try {
            new DefaultSecurityTokenDecoder((ContainerConfig)new FakeContainerConfig("secure"));
            Assert.fail((String)"Should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("root cause should have been FileNotFoundException: " + e), (boolean)e.getMessage().contains("FileNotFoundException: container key file: somecontainer"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeContainerConfig
    extends AbstractContainerConfig {
        private final String tokenType;

        public FakeContainerConfig(String tokenType) throws ContainerConfigException {
            this.tokenType = tokenType;
        }

        public Object getProperty(String container, String parameter) {
            if ("gadgets.securityTokenType".equals(parameter)) {
                if ("default".equals(container)) {
                    return this.tokenType;
                }
            } else if ("gadgets.securityTokenKeyFile".equals(parameter)) {
                return "container key file: " + container;
            }
            return null;
        }

        public Collection<String> getContainers() {
            return Lists.newArrayList((Object[])new String[]{"somecontainer"});
        }
    }
}

