/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shindig.config.ContainerConfigException;
import org.apache.shindig.config.JsonContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class JsonContainerConfigTest {
    private static final String TOP_LEVEL_NAME = "Top level name";
    private static final String TOP_LEVEL_VALUE = "Top level value";
    private static final String NESTED_KEY = "ne$ted";
    private static final String NESTED_NAME = "Nested name";
    private static final String NESTED_VALUE = "Nested value";
    private static final String NESTED_ALT_VALUE = "Nested value alt";
    private static final String CHILD_CONTAINER = "child";
    private static final String CONTAINER_A = "container-a";
    private static final String CONTAINER_B = "container-b";
    private static final String ARRAY_NAME = "array value";
    private static final String[] ARRAY_VALUE = new String[]{"Hello", "World"};
    private static final String ARRAY_ALT_VALUE = "Not an array";

    private File createContainer(JSONObject json) throws Exception {
        File file = File.createTempFile(this.getClass().getName(), ".json");
        file.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(json.toString());
        out.close();
        return file;
    }

    private File createDefaultContainer() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put(TOP_LEVEL_NAME, (Object)TOP_LEVEL_VALUE);
        json.put(ARRAY_NAME, (Object)ARRAY_VALUE);
        JSONObject nested = new JSONObject();
        nested.put(NESTED_NAME, (Object)NESTED_VALUE);
        json.put(NESTED_KEY, (Object)nested);
        return this.createContainer(json);
    }

    @Test
    public void parseBasicConfig() throws Exception {
        JsonContainerConfig config = new JsonContainerConfig(this.createDefaultContainer().getAbsolutePath(), Expressions.forTesting());
        Assert.assertEquals((long)1L, (long)config.getContainers().size());
        for (String container : config.getContainers()) {
            Assert.assertEquals((Object)"default", (Object)container);
        }
        String value = config.getString("default", TOP_LEVEL_NAME);
        Assert.assertEquals((Object)TOP_LEVEL_VALUE, (Object)value);
        Map nested = config.getMap("default", NESTED_KEY);
        String nestedValue = nested.get(NESTED_NAME).toString();
        Assert.assertEquals((Object)NESTED_VALUE, (Object)nestedValue);
    }

    @Test
    public void aliasesArePopulated() throws Exception {
        JSONObject json = new JSONObject().put("gadgets.container", (Object)new String[]{CONTAINER_A, CONTAINER_B}).put(NESTED_KEY, (Object)NESTED_VALUE);
        File parentFile = this.createDefaultContainer();
        File childFile = this.createContainer(json);
        JsonContainerConfig config = new JsonContainerConfig(childFile.getAbsolutePath() + ',' + parentFile.getAbsolutePath(), Expressions.forTesting());
        Assert.assertEquals((Object)NESTED_VALUE, (Object)config.getString(CONTAINER_A, NESTED_KEY));
        Assert.assertEquals((Object)NESTED_VALUE, (Object)config.getString(CONTAINER_B, NESTED_KEY));
    }

    @Test
    public void parseWithDefaultInheritance() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{CHILD_CONTAINER});
        json.put("parent", (Object)"default");
        json.put(ARRAY_NAME, (Object)ARRAY_ALT_VALUE);
        JSONObject nested = new JSONObject();
        nested.put(NESTED_NAME, (Object)NESTED_ALT_VALUE);
        json.put(NESTED_KEY, (Object)nested);
        File childFile = this.createContainer(json);
        File parentFile = this.createDefaultContainer();
        JsonContainerConfig config = new JsonContainerConfig(childFile.getAbsolutePath() + ',' + parentFile.getAbsolutePath(), Expressions.forTesting());
        String value = config.getString(CHILD_CONTAINER, TOP_LEVEL_NAME);
        Assert.assertEquals((Object)TOP_LEVEL_VALUE, (Object)value);
        Map nestedObj = config.getMap(CHILD_CONTAINER, NESTED_KEY);
        String nestedValue = nestedObj.get(NESTED_NAME).toString();
        Assert.assertEquals((Object)NESTED_ALT_VALUE, (Object)nestedValue);
        String arrayValue = config.getString(CHILD_CONTAINER, ARRAY_NAME);
        Assert.assertEquals((Object)ARRAY_ALT_VALUE, (Object)arrayValue);
        ArrayList<String> actual = new ArrayList<String>();
        for (Object val : config.getList("default", ARRAY_NAME)) {
            actual.add(val.toString());
        }
        List<String> expected = Arrays.asList(ARRAY_VALUE);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void invalidContainerReturnsNull() throws Exception {
        JsonContainerConfig config = new JsonContainerConfig(this.createDefaultContainer().getAbsolutePath(), Expressions.forTesting());
        Assert.assertNull((String)"Did not return null for invalid container.", (Object)config.getString("fake", "parent"));
    }

    @Test(expected=ContainerConfigException.class)
    public void badConfigThrows() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{CHILD_CONTAINER});
        json.put("parent", (Object)"bad bad bad parent!");
        json.put(ARRAY_NAME, (Object)ARRAY_ALT_VALUE);
        new JsonContainerConfig(this.createContainer(json).getAbsolutePath(), Expressions.forTesting());
    }

    @Test
    public void pathQuery() throws Exception {
        JsonContainerConfig config = new JsonContainerConfig(this.createDefaultContainer().getAbsolutePath(), Expressions.forTesting());
        String path = "${ne$ted['Nested name']}";
        String data = config.getString("default", path);
        Assert.assertEquals((Object)NESTED_VALUE, (Object)data);
    }

    @Test
    public void expressionEvaluation() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put("expression", (Object)"Hello, ${world}!");
        json.put("world", (Object)"Earth");
        JsonContainerConfig config = new JsonContainerConfig(this.createContainer(json).getAbsolutePath(), Expressions.forTesting());
        Assert.assertEquals((Object)"Hello, Earth!", (Object)config.getString("default", "expression"));
    }

    @Test
    public void expressionEvaluationUsingParent() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{CHILD_CONTAINER});
        json.put("parent", (Object)"default");
        json.put("parentExpression", (Object)"${parent['Top level name']}");
        File childFile = this.createContainer(json);
        File parentFile = this.createDefaultContainer();
        JsonContainerConfig config = new JsonContainerConfig(childFile.getAbsolutePath() + ',' + parentFile.getAbsolutePath(), Expressions.forTesting());
        Assert.assertEquals((Object)TOP_LEVEL_VALUE, (Object)config.getString(CHILD_CONTAINER, "parentExpression"));
    }

    @Test
    public void nullEntryEvaluation() throws Exception {
        JSONObject json = new JSONObject("{ 'gadgets.container' : ['default'], features : { osapi : null }}");
        JsonContainerConfig config = new JsonContainerConfig(this.createContainer(json).getAbsolutePath(), Expressions.forTesting());
        Assert.assertNull(config.getMap("default", "features").get("osapi"));
    }
}

