/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import java.util.Set;
import junit.framework.TestCase;
import org.apache.shindig.protocol.ContentTypes;

public class ContentTypesTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    public void testAllowJson() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"application/json", (boolean)true);
    }

    public void testAllowAtom() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_ATOM_CONTENT_TYPES, (String)"application/atom+xml", (boolean)true);
    }

    public void testAllowXml() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_XML_CONTENT_TYPES, (String)"application/xml", (boolean)true);
    }

    public void testAllowMultipart() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_MULTIPART_CONTENT_TYPES, (String)"multipart/form-data", (boolean)true);
    }

    public void testForbidden() throws Exception {
        try {
            ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"application/x-www-form-urlencoded", (boolean)false);
            ContentTypesTest.fail((String)"Should fail as form encoded is forbidden");
        }
        catch (ContentTypes.InvalidContentTypeException invalidContentTypeException) {
            // empty catch block
        }
    }

    public void testStrictDisallowUnknown() throws Exception {
        try {
            ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"text/plain", (boolean)true);
            ContentTypesTest.fail((String)"Should fail with strict content type checking enabled");
        }
        catch (ContentTypes.InvalidContentTypeException invalidContentTypeException) {
            // empty catch block
        }
    }

    public void testNonStrictAllowUnknown() throws Exception {
        ContentTypes.checkContentTypes((Set)ContentTypes.ALLOWED_JSON_CONTENT_TYPES, (String)"text/plain", (boolean)false);
    }

    public void textExtractMimePart() throws Exception {
        ContentTypesTest.assertEquals((String)"text/xml", (String)ContentTypes.extractMimePart((String)"Text/Xml ; charset = ISO-8859-1;x=y"));
    }
}

