/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.DomUtil;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

@ImplementedBy(value=NekoSimplifiedHtmlParser.class)
public abstract class GadgetHtmlParser {
    public static final String PARSED_DOCUMENTS = "parsedDocuments";
    private Cache<String, Document> documentCache;

    @Inject
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.documentCache = cacheProvider.createCache(PARSED_DOCUMENTS);
    }

    protected static boolean attemptFullDocParseFirst(String content) {
        String normalized = content.substring(Math.min(100, content.length())).toUpperCase();
        return normalized.contains("<!DOCTYPE") || normalized.contains("<HTML");
    }

    public final Document parseDom(String source) throws GadgetException {
        Document document = null;
        String key = null;
        boolean shouldCache = this.shouldCache();
        if (shouldCache) {
            key = HashUtil.rawChecksum((byte[])source.getBytes());
            document = (Document)this.documentCache.getElement((Object)key);
        }
        if (document == null) {
            document = this.parseDomImpl(source);
            if (DomUtil.getFirstNamedChildNode(document.getDocumentElement(), "head") == null) {
                document.getDocumentElement().insertBefore(document.createElement("head"), document.getDocumentElement().getFirstChild());
            }
            if (DomUtil.getFirstNamedChildNode(document.getDocumentElement(), "body") == null) {
                document.getDocumentElement().appendChild(document.createElement("body"));
            }
            if (shouldCache) {
                this.documentCache.addElement((Object)key, (Object)document);
            }
        }
        if (shouldCache) {
            Document copy = (Document)document.cloneNode(true);
            HtmlSerializer.copySerializer(document, copy);
            return copy;
        }
        return document;
    }

    private boolean shouldCache() {
        return this.documentCache != null && this.documentCache.getCapacity() != 0L;
    }

    protected abstract Document parseDomImpl(String var1) throws GadgetException;

    protected void normalizeFragment(Document document, DocumentFragment fragment) {
        Node htmlNode = DomUtil.getFirstNamedChildNode(fragment, "HTML");
        if (htmlNode != null) {
            document.appendChild(htmlNode);
        } else {
            Node bodyNode = DomUtil.getFirstNamedChildNode(fragment, "body");
            Node headNode = DomUtil.getFirstNamedChildNode(fragment, "head");
            if (bodyNode != null || headNode != null) {
                Node root = document.appendChild(document.createElement("html"));
                if (headNode != null && bodyNode == null) {
                    fragment.removeChild(headNode);
                    root.appendChild(headNode);
                    Node body = root.appendChild(document.createElement("body"));
                    body.appendChild(fragment);
                } else {
                    root.appendChild(fragment);
                }
            } else {
                Node root = document.appendChild(document.createElement("html"));
                Node body = root.appendChild(document.createElement("body"));
                body.appendChild(fragment);
            }
        }
    }
}

