/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class FetchResponseUtilsTest {
    @Test
    public void testSimpleResponse() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).create();
        JSONObject obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, (String)"body");
        Assert.assertEquals((long)999L, (long)obj.getInt("rc"));
        Assert.assertEquals((Object)"body", (Object)obj.getString("body"));
        Assert.assertEquals((long)0L, (long)obj.getJSONObject("headers").length());
    }

    @Test
    public void testMetadata() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).setMetadata("metaname", "metavalue").setMetadata("more meta", "more value").create();
        JSONObject obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, (String)"body");
        Assert.assertEquals((long)999L, (long)obj.getInt("rc"));
        Assert.assertEquals((Object)"body", (Object)obj.getString("body"));
        Assert.assertEquals((Object)"metavalue", (Object)obj.getString("metaname"));
        Assert.assertEquals((Object)"more value", (Object)obj.getString("more meta"));
    }

    @Test
    public void testHeaders() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).setHeader("Set-Cookie", "cookie").setHeader("location", "somewhere").create();
        JSONObject obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, (String)"body");
        Assert.assertEquals((long)999L, (long)obj.getInt("rc"));
        Assert.assertEquals((Object)"body", (Object)obj.getString("body"));
        Assert.assertEquals((long)1L, (long)obj.getJSONObject("headers").getJSONArray("set-cookie").length());
        Assert.assertEquals((Object)"cookie", (Object)obj.getJSONObject("headers").getJSONArray("set-cookie").get(0));
        Assert.assertEquals((long)1L, (long)obj.getJSONObject("headers").getJSONArray("location").length());
        Assert.assertEquals((Object)"somewhere", (Object)obj.getJSONObject("headers").getJSONArray("location").get(0));
    }

    @Test
    public void testMultiValuedHeaders() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).addHeader("Set-Cookie", "cookie").addHeader("Set-Cookie", "cookie2").addHeader("Set-Cookie", "cookie3").create();
        JSONObject obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, (String)"body");
        Assert.assertEquals((long)999L, (long)obj.getInt("rc"));
        Assert.assertEquals((Object)"body", (Object)obj.getString("body"));
        Assert.assertEquals((long)3L, (long)obj.getJSONObject("headers").getJSONArray("set-cookie").length());
        Assert.assertEquals((Object)"cookie", (Object)obj.getJSONObject("headers").getJSONArray("set-cookie").get(0));
        Assert.assertEquals((Object)"cookie2", (Object)obj.getJSONObject("headers").getJSONArray("set-cookie").get(1));
        Assert.assertEquals((Object)"cookie3", (Object)obj.getJSONObject("headers").getJSONArray("set-cookie").get(2));
    }
}

