/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.http.FakeHttpServer;
import org.mortbay.jetty.servlet.ServletHolder;

public class EchoServer
extends FakeHttpServer {
    public static final String STATUS_PARAM = "status";
    public static final String BODY_PARAM = "body";
    public static final String HEADER_PARAM = "header";

    protected void addServlets() throws Exception {
        ServletHolder servletHolder = new ServletHolder((Servlet)new EchoServlet());
        this.context.addServlet(servletHolder, "/*");
    }

    private static class EchoServlet
    extends HttpServlet {
        private EchoServlet() {
        }

        protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.handleEcho(req, resp);
        }

        private void handleEcho(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            int code = 200;
            if (req.getParameter(EchoServer.STATUS_PARAM) != null) {
                code = Integer.parseInt(req.getParameter(EchoServer.STATUS_PARAM));
            }
            resp.setStatus(code);
            String[] headers = req.getParameterValues(EchoServer.HEADER_PARAM);
            if (headers != null) {
                for (String header : headers) {
                    String[] nameAndValue = header.split("=", 2);
                    resp.setHeader(nameAndValue[0], nameAndValue[1]);
                }
            }
            resp.setHeader("X-Method", req.getMethod());
            String body = req.getParameter(EchoServer.BODY_PARAM);
            if (body != null) {
                resp.getWriter().print(body);
            } else {
                int len;
                resp.setHeader("Content-Type", "application/octet-stream");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ServletInputStream is = req.getInputStream();
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    baos.write(buf, 0, len);
                }
                ServletOutputStream os = resp.getOutputStream();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                while ((len = bais.read(buf)) > 0) {
                    os.write(buf, 0, len);
                }
            }
        }
    }
}

