/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.gadgets.FakeGadgetSpecFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.oauth.AccessorInfo;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerIndex;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.GadgetOAuthTokenStore;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GadgetTokenStoreTest {
    private static final String GADGET_URL = "http://www.example.com/gadget.xml";
    public static final String GADGET_SPEC = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n  <Module>\n    <ModulePrefs title=\"hello world example\">\n   \n    <OAuth>\n      <Service name='testservice'>        <Access           url='http://www.example.com/access'          param_location='uri-query'           method='GET'        />        <Request           url='http://www.example.com/request?param=foo'          param_location='uri-query'           method='GET'        />        <Authorization           url='http://www.example.com/authorize'        />      </Service>    </OAuth>\n    </ModulePrefs>\n    <Content type=\"html\">\n       <![CDATA[\n         Hello, world!\n       ]]>\n       \n    </Content>\n  </Module>";
    private BasicOAuthStore backingStore;
    private GadgetOAuthTokenStore store;
    private FakeGadgetToken socialToken;
    private FakeGadgetToken privateToken;
    private BlobCrypter stateCrypter;
    private OAuthClientState clientState;

    @Before
    public void setUp() throws Exception {
        this.backingStore = new BasicOAuthStore();
        this.backingStore.setDefaultKey(new BasicOAuthStoreConsumerKeyAndSecret("key", "secret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, "keyname"));
        this.store = new GadgetOAuthTokenStore((OAuthStore)this.backingStore, (GadgetSpecFactory)new FakeGadgetSpecFactory());
        this.socialToken = new FakeGadgetToken();
        this.socialToken.setOwnerId("owner");
        this.socialToken.setViewerId("viewer");
        this.socialToken.setAppUrl(GADGET_URL);
        this.privateToken = new FakeGadgetToken();
        this.privateToken.setOwnerId("owner");
        this.privateToken.setViewerId("owner");
        this.privateToken.setAppUrl(GADGET_URL);
        this.stateCrypter = new BasicBlobCrypter("abcdefghijklmnop".getBytes());
        this.clientState = new OAuthClientState(this.stateCrypter);
    }

    @Test
    public void testGetOAuthAccessor_signedFetch() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setUseToken(OAuthArguments.UseToken.NEVER);
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals((Object)"keyname", (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"key", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertNull((Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testGetOAuthAccessor_useToken_noOAuthInSpec() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setUseToken(OAuthArguments.UseToken.IF_AVAILABLE);
        try {
            this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
            Assert.fail();
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    @Test
    public void testGetOAuthAccessor_signedFetch_hmacKey() throws Exception {
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(GADGET_URL);
        index.setServiceName("hmac");
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("hmac", "hmacsecret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC, null);
        this.backingStore.setConsumerKeyAndSecret(index, cks);
        OAuthArguments arguments = new OAuthArguments();
        arguments.setUseToken(OAuthArguments.UseToken.NEVER);
        arguments.setServiceName("hmac");
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals(null, (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"hmac", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertEquals((Object)"hmacsecret", (Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testGetOAuthAccessor_signedFetch_badServiceName() throws Exception {
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(GADGET_URL);
        index.setServiceName("otherservice");
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("hmac", "hmacsecret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC, null);
        this.backingStore.setConsumerKeyAndSecret(index, cks);
        OAuthArguments arguments = new OAuthArguments();
        arguments.setUseToken(OAuthArguments.UseToken.NEVER);
        arguments.setServiceName("hmac");
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
        Assert.assertEquals((Object)"keyname", (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"key", (Object)info.getConsumer().getConsumer().consumerKey);
    }

    @Test
    public void testGetOAuthAccessor_signedFetch_defaultHmac() throws Exception {
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(GADGET_URL);
        index.setServiceName("");
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("hmac", "hmacsecret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC, null);
        this.backingStore.setConsumerKeyAndSecret(index, cks);
        OAuthArguments arguments = new OAuthArguments();
        arguments.setUseToken(OAuthArguments.UseToken.NEVER);
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals(null, (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"hmac", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertEquals((Object)"hmacsecret", (Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testGetOAuthAccessor_socialOAuth_socialPage() throws Exception {
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(GADGET_URL);
        index.setServiceName("testservice");
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("hmac", "hmacsecret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC, null);
        this.backingStore.setConsumerKeyAndSecret(index, cks);
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.IF_AVAILABLE);
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals(null, (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"hmac", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertEquals((Object)"hmacsecret", (Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testGetOAuthAccessor_socialOAuth_privatePage() throws Exception {
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(GADGET_URL);
        index.setServiceName("testservice");
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("hmac", "hmacsecret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC, null);
        this.backingStore.setConsumerKeyAndSecret(index, cks);
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.IF_AVAILABLE);
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals(null, (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"hmac", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertEquals((Object)"hmacsecret", (Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testGetOAuthAccessor_socialOAuth_withToken() throws Exception {
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(GADGET_URL);
        index.setServiceName("testservice");
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("hmac", "hmacsecret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC, null);
        this.backingStore.setConsumerKeyAndSecret(index, cks);
        this.backingStore.setTokenInfo((SecurityToken)this.privateToken, null, "testservice", "", new OAuthStore.TokenInfo("token", "secret", null, 0L));
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.IF_AVAILABLE);
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals(null, (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"hmac", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertEquals((Object)"hmacsecret", (Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertEquals((Object)"token", (Object)info.getAccessor().accessToken);
        Assert.assertEquals((Object)"secret", (Object)info.getAccessor().tokenSecret);
        info = this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals(null, (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"hmac", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertEquals((Object)"hmacsecret", (Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testGetOAuthAccessor_fullOAuth_socialPage() throws Exception {
        BasicOAuthStoreConsumerIndex index = new BasicOAuthStoreConsumerIndex();
        index.setGadgetUri(GADGET_URL);
        index.setServiceName("testservice");
        BasicOAuthStoreConsumerKeyAndSecret cks = new BasicOAuthStoreConsumerKeyAndSecret("hmac", "hmacsecret", BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC, null);
        this.backingStore.setConsumerKeyAndSecret(index, cks);
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.URI_QUERY, (Object)info.getParamLocation());
        Assert.assertEquals(null, (Object)info.getConsumer().getKeyName());
        Assert.assertEquals((Object)"hmac", (Object)info.getConsumer().getConsumer().consumerKey);
        Assert.assertEquals((Object)"hmacsecret", (Object)info.getConsumer().getConsumer().consumerSecret);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testGetOAuthAccessor_serviceNotFound() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("no such service");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        try {
            this.store.getOAuthAccessor((SecurityToken)this.socialToken, arguments, this.clientState);
            Assert.fail();
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    @Test
    public void testGetOAuthAccessor_oauthParamsInBody() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        this.privateToken.setAppUrl("http://www.example.com/body.xml");
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertEquals((Object)"http://www.example.com/request?param=foo", (Object)info.getConsumer().getConsumer().serviceProvider.requestTokenURL);
        Assert.assertEquals((Object)"http://www.example.com/authorize", (Object)info.getConsumer().getConsumer().serviceProvider.userAuthorizationURL);
        Assert.assertEquals((Object)"http://www.example.com/access", (Object)info.getConsumer().getConsumer().serviceProvider.accessTokenURL);
        Assert.assertEquals((Object)AccessorInfo.HttpMethod.POST, (Object)info.getHttpMethod());
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.POST_BODY, (Object)info.getParamLocation());
    }

    @Test
    public void testGetOAuthAccessor_oauthParamsInHeader() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        this.privateToken.setAppUrl("http://www.example.com/header.xml");
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertEquals((Object)"http://www.example.com/request?param=foo", (Object)info.getConsumer().getConsumer().serviceProvider.requestTokenURL);
        Assert.assertEquals((Object)"http://www.example.com/authorize", (Object)info.getConsumer().getConsumer().serviceProvider.userAuthorizationURL);
        Assert.assertEquals((Object)"http://www.example.com/access", (Object)info.getConsumer().getConsumer().serviceProvider.accessTokenURL);
        Assert.assertEquals((Object)AccessorInfo.HttpMethod.GET, (Object)info.getHttpMethod());
        Assert.assertEquals((Object)AccessorInfo.OAuthParamLocation.AUTH_HEADER, (Object)info.getParamLocation());
    }

    @Test
    public void testAccessTokenFromServerDatabase() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        this.store.storeTokenKeyAndSecret((SecurityToken)this.privateToken, null, arguments, new OAuthStore.TokenInfo("access", "secret", "sessionhandle", 12345L));
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertEquals((Object)"access", (Object)info.getAccessor().accessToken);
        Assert.assertEquals((Object)"secret", (Object)info.getAccessor().tokenSecret);
        Assert.assertEquals((Object)"sessionhandle", (Object)info.getSessionHandle());
        Assert.assertEquals((long)12345L, (long)info.getTokenExpireMillis());
    }

    @Test
    public void testAccessTokenFromClient() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        this.store.storeTokenKeyAndSecret((SecurityToken)this.privateToken, null, arguments, new OAuthStore.TokenInfo("access", "secret", null, 0L));
        this.clientState.setAccessToken("clienttoken");
        this.clientState.setAccessTokenSecret("clienttokensecret");
        this.clientState.setSessionHandle("clienthandle");
        this.clientState.setTokenExpireMillis(56789L);
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertEquals((Object)"clienttoken", (Object)info.getAccessor().accessToken);
        Assert.assertEquals((Object)"clienttokensecret", (Object)info.getAccessor().tokenSecret);
        Assert.assertEquals((Object)"clienthandle", (Object)info.getSessionHandle());
        Assert.assertEquals((long)56789L, (long)info.getTokenExpireMillis());
    }

    @Test
    public void testRequestTokenFromClientState() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        this.store.storeTokenKeyAndSecret((SecurityToken)this.privateToken, null, arguments, new OAuthStore.TokenInfo("access", "secret", null, 0L));
        this.clientState.setRequestToken("request");
        this.clientState.setRequestTokenSecret("requestsecret");
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertEquals((Object)"request", (Object)info.getAccessor().requestToken);
        Assert.assertEquals((Object)"requestsecret", (Object)info.getAccessor().tokenSecret);
        Assert.assertNull((Object)info.getAccessor().accessToken);
    }

    @Test
    public void testRequestTokenFromClient_preferTokenInStorage() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        arguments.setRequestToken("preapproved");
        arguments.setRequestTokenSecret("preapprovedsecret");
        this.store.storeTokenKeyAndSecret((SecurityToken)this.privateToken, null, arguments, new OAuthStore.TokenInfo("access", "secret", null, 0L));
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertEquals((Object)"access", (Object)info.getAccessor().accessToken);
        Assert.assertEquals((Object)"secret", (Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testRequestTokenFromClient_noTokenInStorage() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        arguments.setRequestToken("preapproved");
        arguments.setRequestTokenSecret("preapprovedsecret");
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertEquals((Object)"preapproved", (Object)info.getAccessor().requestToken);
        Assert.assertEquals((Object)"preapprovedsecret", (Object)info.getAccessor().tokenSecret);
    }

    @Test
    public void testRemoveToken() throws Exception {
        OAuthArguments arguments = new OAuthArguments();
        arguments.setServiceName("testservice");
        arguments.setUseToken(OAuthArguments.UseToken.ALWAYS);
        this.store.storeTokenKeyAndSecret((SecurityToken)this.privateToken, null, arguments, new OAuthStore.TokenInfo("access", "secret", null, 0L));
        AccessorInfo info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertEquals((Object)"access", (Object)info.getAccessor().accessToken);
        Assert.assertEquals((Object)"secret", (Object)info.getAccessor().tokenSecret);
        this.store.removeToken((SecurityToken)this.privateToken, null, arguments);
        info = this.store.getOAuthAccessor((SecurityToken)this.privateToken, arguments, this.clientState);
        Assert.assertNull((Object)info.getAccessor().requestToken);
        Assert.assertNull((Object)info.getAccessor().accessToken);
        Assert.assertNull((Object)info.getAccessor().tokenSecret);
    }
}

