/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.OAuthError;
import org.apache.shindig.gadgets.oauth.OAuthResponseParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuthResponseParamsTest {
    private BlobCrypter crypter;

    @Before
    public void setUp() {
        this.crypter = new BasicBlobCrypter("abcdefafadfaxxxx".getBytes());
    }

    @Test
    public void testSetAndGet() {
        OAuthResponseParams params = new OAuthResponseParams(this.crypter);
        params.getNewClientState().setAccessToken("access");
        params.setAznUrl("aznurl");
        params.setError(OAuthError.BAD_OAUTH_CONFIGURATION);
        params.setErrorText("errortext");
        Assert.assertEquals((Object)"access", (Object)params.getNewClientState().getAccessToken());
        Assert.assertEquals((Object)"aznurl", (Object)params.getAznUrl());
        Assert.assertEquals((Object)OAuthError.BAD_OAUTH_CONFIGURATION, (Object)params.getError());
        Assert.assertEquals((Object)"errortext", (Object)params.getErrorText());
    }

    @Test
    public void testAddParams() {
        OAuthResponseParams params = new OAuthResponseParams(this.crypter);
        params.getNewClientState().setAccessToken("access");
        params.setAznUrl("aznurl");
        params.setError(OAuthError.BAD_OAUTH_CONFIGURATION);
        params.setErrorText("errortext");
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        params.addToResponse(responseBuilder);
        HttpResponse response = responseBuilder.create();
        Assert.assertEquals((Object)"BAD_OAUTH_CONFIGURATION", response.getMetadata().get("oauthError"));
        Assert.assertEquals((Object)"errortext", response.getMetadata().get("oauthErrorText"));
        Assert.assertEquals((Object)"aznurl", response.getMetadata().get("oauthApprovalUrl"));
        Assert.assertNotNull(response.getMetadata().get("oauthState"));
        Assert.assertTrue((((String)response.getMetadata().get("oauthState")).length() > 10 ? 1 : 0) != 0);
    }

    @Test
    public void testAddEmptyParams() {
        OAuthResponseParams params = new OAuthResponseParams(this.crypter);
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        params.addToResponse(responseBuilder);
        HttpResponse response = responseBuilder.create();
        Assert.assertTrue((boolean)response.getMetadata().isEmpty());
    }
}

