/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.Sets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.shindig.gadgets.preload.ConcurrentPreloads;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentPreloadsTest {
    @Test
    public void getKeys() {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add("foo", (Future)TestFuture.returnsNormal());
        preloads.add("throwsInterrupted", (Future)TestFuture.throwsInterrupted());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"foo", "throwsInterrupted"}), (Object)preloads.getKeys());
    }

    @Test
    public void getPreloadedDataNormal() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add("foo", (Future)TestFuture.returnsNormal());
        Assert.assertNotNull((Object)preloads.getData("foo"));
    }

    @Test
    public void getPreloadedDataNull() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add("foo", null);
        Assert.assertNull((Object)preloads.getData("foo"));
    }

    @Test(expected=PreloadException.class)
    public void getPreloadedDataThrowsInterrupted() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add("foo", (Future)TestFuture.throwsInterrupted());
        preloads.getData("foo");
    }

    @Test(expected=PreloadException.class)
    public void getPreloadedThrowsExecution() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add("foo", (Future)TestFuture.throwsExecution());
        preloads.getData("foo");
    }

    @Test(expected=PreloadException.class)
    public void getPreloadedThrowsExecutionWrapped() throws Exception {
        ConcurrentPreloads preloads = new ConcurrentPreloads();
        preloads.add("foo", (Future)TestFuture.throwsExecutionWrapped());
        preloads.getData("foo");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestFuture
    implements Future<PreloadedData> {
        private boolean throwsInterrupted;
        private boolean throwsExecution;
        private boolean throwsExecutionWrapped;

        private TestFuture() {
        }

        public static TestFuture returnsNormal() {
            return new TestFuture();
        }

        public static TestFuture returnsNull() {
            return new TestFuture();
        }

        public static TestFuture throwsInterrupted() {
            TestFuture future = new TestFuture();
            future.throwsInterrupted = true;
            return future;
        }

        public static TestFuture throwsExecution() {
            TestFuture future = new TestFuture();
            future.throwsExecution = true;
            return future;
        }

        public static TestFuture throwsExecutionWrapped() {
            TestFuture future = new TestFuture();
            future.throwsExecutionWrapped = true;
            return future;
        }

        @Override
        public PreloadedData get() throws InterruptedException, ExecutionException {
            if (this.throwsInterrupted) {
                throw new InterruptedException("Interrupted!");
            }
            if (this.throwsExecution) {
                throw new ExecutionException(new RuntimeException("Fail"));
            }
            if (this.throwsExecutionWrapped) {
                throw new ExecutionException((Throwable)new PreloadException("Preload failed."));
            }
            return new PreloadedData(){

                public Object toJson() {
                    return "Preloaded";
                }
            };
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public PreloadedData get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }
}

