/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.gadgets.parse.ParsedCssDeclaration;
import org.apache.shindig.gadgets.parse.ParsedCssRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetCssRule {
    private final List<String> selectors = Lists.newLinkedList();
    private final Map<String, String> declarations = Maps.newHashMap();

    public GadgetCssRule(ParsedCssRule source) {
        this();
        for (String selector : source.getSelectors()) {
            this.addSelector(selector, null);
        }
        for (ParsedCssDeclaration decl : source.getDeclarations()) {
            this.setDeclaration(decl.getName(), decl.getValue());
        }
    }

    public GadgetCssRule() {
    }

    public boolean addSelector(String selector, String before) {
        int selIx = this.selectors.indexOf(selector = selector.trim());
        if (selIx >= 0) {
            return false;
        }
        if (before == null) {
            return this.selectors.add(selector);
        }
        int befIx = this.selectors.indexOf(before);
        if (befIx >= 0) {
            this.selectors.add(befIx, selector);
        } else {
            this.selectors.add(selector);
        }
        return true;
    }

    public boolean removeSelector(String selector) {
        return this.selectors.remove(selector);
    }

    public boolean hasSelector(String selector) {
        return this.selectors.contains(selector);
    }

    public List<String> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    public void setDeclaration(String key, String value) {
        key = key.trim();
        this.declarations.put(key, value);
    }

    public boolean removeDeclaration(String key) {
        return this.declarations.remove(key = key.trim()) != null;
    }

    public String getDeclarationValue(String key) {
        key = key.trim();
        return this.declarations.get(key);
    }

    public Set<String> getDeclarationKeys() {
        return Collections.unmodifiableSet(this.declarations.keySet());
    }
}

