/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetBlacklist;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.variables.VariableSubstituter;
import org.json.JSONArray;

@Singleton
public class Processor {
    private static final Logger LOG = Logger.getLogger(Processor.class.getName());
    private final GadgetSpecFactory gadgetSpecFactory;
    private final VariableSubstituter substituter;
    private final ContainerConfig containerConfig;
    private final GadgetBlacklist blacklist;

    @Inject
    public Processor(GadgetSpecFactory gadgetSpecFactory, VariableSubstituter substituter, ContainerConfig containerConfig, GadgetBlacklist blacklist) {
        this.gadgetSpecFactory = gadgetSpecFactory;
        this.substituter = substituter;
        this.blacklist = blacklist;
        this.containerConfig = containerConfig;
    }

    public Gadget process(GadgetContext context) throws ProcessingException {
        URI url = context.getUrl();
        if (url == null) {
            throw new ProcessingException("Missing or malformed url parameter");
        }
        if (!"http".equalsIgnoreCase(url.getScheme()) && !"https".equalsIgnoreCase(url.getScheme())) {
            throw new ProcessingException("Unsupported scheme (must be http or https).");
        }
        if (this.blacklist.isBlacklisted(context.getUrl())) {
            LOG.info("Attempted to render blacklisted gadget: " + context.getUrl());
            throw new ProcessingException("The requested gadget is unavailable");
        }
        try {
            GadgetSpec spec = this.gadgetSpecFactory.getGadgetSpec(context);
            spec = this.substituter.substitute(context, spec);
            return new Gadget().setContext(context).setSpec(spec).setCurrentView(this.getView(context, spec));
        }
        catch (GadgetException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private View getView(GadgetContext context, GadgetSpec spec) {
        String viewName = context.getView();
        View view = spec.getView(viewName);
        if (view == null) {
            JSONArray aliases = this.containerConfig.getJsonArray(context.getContainer(), "gadgets.features/views/" + viewName + "/aliases");
            if (aliases != null) {
                int j = aliases.length();
                for (int i = 0; i < j && ((viewName = aliases.optString(i)) == null || (view = spec.getView(viewName)) == null); ++i) {
                }
            }
            if (view == null) {
                view = spec.getView("default");
            }
        }
        return view;
    }
}

