/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpCacheKey;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class HttpCacheKeyTest {
    private Uri target = Uri.parse((String)"http://www.example.com/");

    @Test
    public void testGet() throws Exception {
        HttpRequest request = new HttpRequest(this.target);
        HttpCacheKey key = new HttpCacheKey(request);
        Assert.assertTrue((boolean)key.isCacheable());
        Assert.assertEquals((Object)"[{\"method\":\"GET\"},{\"url\":\"http://www.example.com/\"}]", (Object)key.toString());
    }

    @Test
    public void testNonCacheableOptions() throws Exception {
        HttpRequest request = new HttpRequest(this.target).setIgnoreCache(true);
        HttpCacheKey key = new HttpCacheKey(request);
        Assert.assertFalse((boolean)key.isCacheable());
        Assert.assertEquals((Object)"[{\"method\":\"GET\"},{\"url\":\"http://www.example.com/\"}]", (Object)key.toString());
    }

    @Test
    public void testNonGet() throws Exception {
        HttpRequest request = new HttpRequest(this.target).setMethod("POST");
        HttpCacheKey key = new HttpCacheKey(request);
        Assert.assertFalse((boolean)key.isCacheable());
        Assert.assertEquals((Object)"[{\"method\":\"POST\"},{\"url\":\"http://www.example.com/\"}]", (Object)key.toString());
    }

    @Test
    public void testOrdered() {
        HttpCacheKey key = new HttpCacheKey(new HttpRequest(this.target));
        key.set("c", "c");
        key.set("b", "b");
        key.set("g", "g");
        key.set("d", "d");
        key.set("e", "e");
        key.set("f", "f");
        key.set("g", "g");
        key.set("a", "a");
        Assert.assertEquals((Object)"[{\"a\":\"a\"},{\"b\":\"b\"},{\"c\":\"c\"},{\"d\":\"d\"},{\"e\":\"e\"},{\"f\":\"f\"},{\"g\":\"g\"},{\"method\":\"GET\"},{\"url\":\"http://www.example.com/\"}]", (Object)key.toString());
    }

    @Test
    public void testWeirdChars() throws Exception {
        int CHARS_TO_TEST = 2000;
        HttpCacheKey key = new HttpCacheKey(new HttpRequest(this.target));
        for (char c = '\u0000'; c <= '\u07d0'; c = (char)(c + '\u0001')) {
            key.set(Character.toString(c), Character.toString(c));
        }
        key.remove("url");
        key.remove("method");
        String out = key.toString();
        JSONArray array = new JSONArray(out);
        for (char c = '\u0000'; c <= '\u07d0'; c = (char)(c + '\u0001')) {
            JSONObject o = array.getJSONObject((int)c);
            String s = Character.toString(c);
            Assert.assertEquals((Object)s, (Object)o.get(s));
        }
    }
}

