/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.http.ContentFetcherFactory;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.preload.HttpPreloader;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class HttpPreloaderTest {
    private static final String PRELOAD_HREF = "http://www.example.org/file";
    private static final String PRELOAD_HREF2 = "http://www.example.org/file-two";
    private static final String PRELOAD_CONTENT = "Preloaded data";
    private static final String CONTAINER = "some-container";
    private static final Uri GADGET_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final Map<String, String> PRELOAD_METADATA = ImmutableMap.of((Object)"foo", (Object)"bar");
    private final RecordingHttpFetcher plainFetcher = new RecordingHttpFetcher();
    private final RecordingHttpFetcher oauthFetcher = new RecordingHttpFetcher();
    private final ContentFetcherFactory fetchers = new ContentFetcherFactory(null, null){

        public HttpResponse fetch(HttpRequest request) {
            if (request.getAuthType() == AuthType.NONE) {
                return HttpPreloaderTest.this.plainFetcher.fetch(request);
            }
            return HttpPreloaderTest.this.oauthFetcher.fetch(request);
        }
    };
    private final GadgetContext context = new GadgetContext(){

        public SecurityToken getToken() {
            return new FakeGadgetToken();
        }

        public String getContainer() {
            return HttpPreloaderTest.CONTAINER;
        }

        public URI getUrl() {
            return GADGET_URL.toJavaUri();
        }
    };

    private void checkRequest(HttpRequest request) {
        Assert.assertEquals((Object)this.context.getContainer(), (Object)request.getContainer());
        Assert.assertEquals((Object)GADGET_URL.toString(), (Object)request.getGadget().toString());
        Assert.assertEquals((Object)this.context.getToken().getAppId(), (Object)request.getSecurityToken().getAppId());
    }

    private static void checkResults(JSONObject results) throws JSONException {
        Assert.assertEquals((Object)PRELOAD_CONTENT, (Object)results.get("body"));
        Assert.assertEquals((long)200L, (long)results.getInt("rc"));
        Assert.assertEquals((Object)"yo=momma", (Object)results.getJSONObject("headers").getJSONArray("set-cookie").get(0));
        for (Map.Entry<String, String> entry : PRELOAD_METADATA.entrySet()) {
            Assert.assertEquals((String)"Metadata values not copied to output.", (Object)entry.getValue(), (Object)results.get(entry.getKey()));
        }
    }

    @Test
    public void normalPreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file'/></ModulePrefs><Content/></Module>";
        GadgetSpec gadget = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.fetchers);
        Map preloaded = preloader.createPreloadTasks(this.context, gadget);
        PreloadedData data = (PreloadedData)((Callable)preloaded.get(PRELOAD_HREF)).call();
        this.checkRequest((HttpRequest)this.plainFetcher.requests.get(0));
        HttpPreloaderTest.checkResults((JSONObject)data.toJson());
    }

    @Test
    public void signedPreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file' authz='signed' sign_viewer='false'/></ModulePrefs><Content/></Module>";
        GadgetSpec gadget = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.fetchers);
        Map preloaded = preloader.createPreloadTasks(this.context, gadget);
        PreloadedData data = (PreloadedData)((Callable)preloaded.get(PRELOAD_HREF)).call();
        HttpRequest request = (HttpRequest)this.oauthFetcher.requests.get(0);
        this.checkRequest(request);
        Assert.assertTrue((boolean)request.getOAuthArguments().getSignOwner());
        Assert.assertFalse((boolean)request.getOAuthArguments().getSignViewer());
        HttpPreloaderTest.checkResults((JSONObject)data.toJson());
    }

    @Test
    public void oauthPreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file' authz='oauth'/></ModulePrefs><Content/></Module>";
        GadgetSpec gadget = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.fetchers);
        Map preloaded = preloader.createPreloadTasks(this.context, gadget);
        PreloadedData data = (PreloadedData)((Callable)preloaded.get(PRELOAD_HREF)).call();
        HttpRequest request = (HttpRequest)this.oauthFetcher.requests.get(0);
        this.checkRequest(request);
        HttpPreloaderTest.checkResults((JSONObject)data.toJson());
    }

    @Test
    public void multiplePreloads() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file'/> <Preload href='http://www.example.org/file-two'/></ModulePrefs><Content/></Module>";
        GadgetSpec gadget = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.fetchers);
        Map preloaded = preloader.createPreloadTasks(this.context, gadget);
        PreloadedData data = (PreloadedData)((Callable)preloaded.get(PRELOAD_HREF)).call();
        this.checkRequest((HttpRequest)this.plainFetcher.requests.get(0));
        HttpPreloaderTest.checkResults((JSONObject)data.toJson());
        data = (PreloadedData)((Callable)preloaded.get(PRELOAD_HREF2)).call();
        this.checkRequest((HttpRequest)this.plainFetcher.requests.get(1));
        HttpPreloaderTest.checkResults((JSONObject)data.toJson());
    }

    @Test
    public void onlyPreloadForCorrectView() throws Exception {
        String xml = "<Module><ModulePrefs title=''> <Preload href='http://www.example.org/file' views='foo,bar,baz'/> <Preload href='http://www.example.org/file-two' views='bar'/></ModulePrefs><Content/></Module>";
        GadgetSpec gadget = new GadgetSpec(GADGET_URL, xml);
        HttpPreloader preloader = new HttpPreloader(this.fetchers);
        GadgetContext fooViewContext = new GadgetContext(){

            public SecurityToken getToken() {
                return new FakeGadgetToken();
            }

            public String getContainer() {
                return HttpPreloaderTest.CONTAINER;
            }

            public URI getUrl() {
                return GADGET_URL.toJavaUri();
            }

            public String getView() {
                return "foo";
            }
        };
        Map preloaded = preloader.createPreloadTasks(fooViewContext, gadget);
        PreloadedData data = (PreloadedData)((Callable)preloaded.get(PRELOAD_HREF)).call();
        this.checkRequest((HttpRequest)this.plainFetcher.requests.get(0));
        HttpPreloaderTest.checkResults((JSONObject)data.toJson());
        Assert.assertNull((String)"Preloaded an item that should not have been.", preloaded.get(PRELOAD_HREF2));
    }

    private static class RecordingHttpFetcher
    implements HttpFetcher {
        private final List<HttpRequest> requests = Lists.newArrayList();

        private RecordingHttpFetcher() {
        }

        public HttpResponse fetch(HttpRequest request) {
            this.requests.add(request);
            return new HttpResponseBuilder().setMetadata(PRELOAD_METADATA).setResponseString(HttpPreloaderTest.PRELOAD_CONTENT).addHeader("Set-Cookie", "yo=momma").create();
        }
    }
}

