/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.EasyMockTestCase;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.spec.GadgetSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRewriterTestCase
extends EasyMockTestCase {
    public static final Uri SPEC_URL = Uri.parse((String)"http://www.example.org/dir/g.xml");
    public static final String DEFAULT_PROXY_BASE = "http://www.test.com/dir/proxy?url=";
    public static final String DEFAULT_CONCAT_BASE = "http://www.test.com/dir/concat?";
    protected Set<String> tags;
    protected ContentRewriterFeature defaultRewriterFeature;
    protected ContentRewriterFeatureFactory rewriterFeatureFactory;
    protected LinkRewriter defaultLinkRewriter;
    protected GadgetHtmlParser parser;
    protected Injector injector;
    protected HttpResponse fakeResponse;

    protected void setUp() throws Exception {
        super.setUp();
        this.rewriterFeatureFactory = new ContentRewriterFeatureFactory(null, ".*", "", "HTTP", "embed,img,script,link,style");
        this.defaultRewriterFeature = this.rewriterFeatureFactory.getDefault();
        this.tags = this.defaultRewriterFeature.getIncludedTags();
        this.defaultLinkRewriter = new ProxyingLinkRewriter(SPEC_URL, this.defaultRewriterFeature, DEFAULT_PROXY_BASE);
        this.injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.parser = (GadgetHtmlParser)this.injector.getInstance(GadgetHtmlParser.class);
        this.fakeResponse = new HttpResponseBuilder().setHeader("Content-Type", "unknown").setResponse(new byte[]{-2, -1}).create();
    }

    public static GadgetSpec createSpecWithRewrite(String include, String exclude, String expires, Set<String> tags) throws GadgetException {
        String xml = "<Module><ModulePrefs title=\"title\"><Optional feature=\"content-rewrite\">\n      <Param name=\"expires\">" + expires + "</Param>\n" + "      <Param name=\"include-urls\">" + include + "</Param>\n" + "      <Param name=\"exclude-urls\">" + exclude + "</Param>\n" + "      <Param name=\"include-tags\">" + StringUtils.join(tags, (String)",") + "</Param>\n" + "</Optional>" + "</ModulePrefs>" + "<Content type=\"html\">Hello!</Content>" + "</Module>";
        return new GadgetSpec(SPEC_URL, xml);
    }

    public static GadgetSpec createSpecWithoutRewrite() throws GadgetException {
        String xml = "<Module><ModulePrefs title=\"title\"></ModulePrefs><Content type=\"html\">Hello!</Content></Module>";
        return new GadgetSpec(SPEC_URL, xml);
    }

    ContentRewriterFeatureFactory mockContentRewriterFeatureFactory(ContentRewriterFeature feature) {
        return new FakeRewriterFeatureFactory(feature);
    }

    String rewriteHelper(ContentRewriter rewriter, String s) throws Exception {
        MutableContent mc = this.rewriteContent(rewriter, s);
        String rewrittenContent = mc.getContent();
        int htmlTagIndex = rewrittenContent.indexOf("<HTML>");
        if (htmlTagIndex != -1) {
            return rewrittenContent.substring(htmlTagIndex + 6, rewrittenContent.lastIndexOf("</HTML>"));
        }
        return rewrittenContent;
    }

    MutableContent rewriteContent(ContentRewriter rewriter, String s) throws Exception {
        MutableContent mc = new MutableContent(this.parser, s);
        GadgetSpec spec = new GadgetSpec(SPEC_URL, "<Module><ModulePrefs title=''/><Content><![CDATA[" + s + "]]></Content></Module>");
        GadgetContext context = new GadgetContext(){

            public URI getUrl() {
                return SPEC_URL.toJavaUri();
            }
        };
        Gadget gadget = new Gadget().setContext(context).setSpec(spec);
        rewriter.rewrite(gadget, mc);
        return mc;
    }

    private static class FakeRewriterFeatureFactory
    extends ContentRewriterFeatureFactory {
        private final ContentRewriterFeature feature;

        public FakeRewriterFeatureFactory(ContentRewriterFeature feature) {
            super(null, ".*", "", "HTTP", "");
            this.feature = feature;
        }

        public ContentRewriterFeature get(GadgetSpec spec) {
            return this.feature;
        }

        public ContentRewriterFeature get(HttpRequest request) {
            return this.feature;
        }
    }
}

