/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.util.Arrays;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class ViewTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");

    @Test
    public void testSimpleView() throws Exception {
        String viewName = "VIEW NAME";
        String content = "This is the content";
        String xml = "<Content type=\"html\" view=\"" + viewName + '\"' + " quirks=\"false\"><![CDATA[" + content + "]]></Content>";
        View view = new View(viewName, Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
        Assert.assertEquals((Object)viewName, (Object)view.getName());
        Assert.assertEquals((Object)false, (Object)view.getQuirks());
        Assert.assertEquals((Object)View.ContentType.HTML, (Object)view.getType());
        Assert.assertEquals((Object)"html", (Object)view.getRawType());
        Assert.assertEquals((Object)content, (Object)view.getContent());
        Assert.assertTrue((String)"Default value for sign_owner should be true.", (boolean)view.isSignOwner());
        Assert.assertTrue((String)"Default value for sign_viewer should be true.", (boolean)view.isSignViewer());
    }

    @Test
    public void testConcatenation() throws Exception {
        String body1 = "Hello, ";
        String body2 = "World!";
        String content1 = "<Content type=\"html\">" + body1 + "</Content>";
        String content2 = "<Content type=\"html\">" + body2 + "</Content>";
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)content1), XmlUtil.parse((String)content2)), SPEC_URL);
        Assert.assertEquals((Object)(body1 + body2), (Object)view.getContent());
    }

    @Test
    public void testNonStandardContentType() throws Exception {
        String contentType = "html-inline";
        String xml = "<Content type=\"" + contentType + '\"' + " quirks=\"false\"><![CDATA[blah]]></Content>";
        View view = new View("default", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
        Assert.assertEquals((Object)View.ContentType.HTML, (Object)view.getType());
        Assert.assertEquals((Object)contentType, (Object)view.getRawType());
    }

    @Test(expected=SpecParserException.class)
    public void testContentTypeConflict() throws Exception {
        String content1 = "<Content type=\"html\"/>";
        String content2 = "<Content type=\"url\" href=\"http://example.org/\"/>";
        new View("test", Arrays.asList(XmlUtil.parse((String)content1), XmlUtil.parse((String)content2)), SPEC_URL);
    }

    @Test(expected=SpecParserException.class)
    public void testHrefOnTypeUrl() throws Exception {
        String xml = "<Content type=\"url\"/>";
        new View("dummy", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
    }

    @Test(expected=SpecParserException.class)
    public void testHrefMalformed() throws Exception {
        String xml = "<Content type=\"url\" href=\"fobad@$%!fdf\"/>";
        new View("dummy", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
    }

    @Test
    public void testQuirksCascade() throws Exception {
        String content1 = "<Content type=\"html\" quirks=\"true\"/>";
        String content2 = "<Content type=\"html\" quirks=\"false\"/>";
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)content1), XmlUtil.parse((String)content2)), SPEC_URL);
        Assert.assertEquals((Object)false, (Object)view.getQuirks());
    }

    @Test
    public void testQuirksCascadeReverse() throws Exception {
        String content1 = "<Content type=\"html\" quirks=\"false\"/>";
        String content2 = "<Content type=\"html\" quirks=\"true\"/>";
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)content1), XmlUtil.parse((String)content2)), SPEC_URL);
        Assert.assertEquals((Object)true, (Object)view.getQuirks());
    }

    @Test
    public void testPreferredHeight() throws Exception {
        String content1 = "<Content type=\"html\" preferred_height=\"100\"/>";
        String content2 = "<Content type=\"html\" preferred_height=\"300\"/>";
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)content1), XmlUtil.parse((String)content2)), SPEC_URL);
        Assert.assertEquals((long)300L, (long)view.getPreferredHeight());
    }

    @Test
    public void testPreferredWidth() throws Exception {
        String content1 = "<Content type=\"html\" preferred_width=\"300\"/>";
        String content2 = "<Content type=\"html\" preferred_width=\"172\"/>";
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)content1), XmlUtil.parse((String)content2)), SPEC_URL);
        Assert.assertEquals((long)172L, (long)view.getPreferredWidth());
    }

    @Test
    public void testContentSubstitution() throws Exception {
        String xml = "<Content type=\"html\">Hello, __MSG_world__ __MODULE_ID__</Content>";
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "world", "foo __UP_planet____BIDI_START_EDGE__");
        substituter.addSubstitution(Substitutions.Type.USER_PREF, "planet", "Earth");
        substituter.addSubstitution(Substitutions.Type.BIDI, "START_EDGE", "right");
        substituter.addSubstitution(Substitutions.Type.MODULE, "ID", "3");
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL).substitute(substituter);
        Assert.assertEquals((Object)"Hello, foo Earthright 3", (Object)view.getContent());
    }

    @Test
    public void testHrefSubstitution() throws Exception {
        String href = "http://__MSG_domain__/__MODULE_ID__?dir=__BIDI_DIR__";
        String xml = "<Content type=\"url\" href=\"" + href + "\"/>";
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "domain", "__UP_subDomain__.example.org");
        substituter.addSubstitution(Substitutions.Type.USER_PREF, "subDomain", "up");
        substituter.addSubstitution(Substitutions.Type.BIDI, "DIR", "rtl");
        substituter.addSubstitution(Substitutions.Type.MODULE, "ID", "123");
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL).substitute(substituter);
        Assert.assertEquals((Object)"http://up.example.org/123?dir=rtl", (Object)view.getHref().toString());
    }

    @Test
    public void testHrefRelativeSubstitution() throws Exception {
        String href = "__MSG_foo__";
        String xml = "<Content type=\"url\" href=\"" + href + "\"/>";
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "foo", "/bar");
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
        view = view.substitute(substituter);
        Assert.assertEquals((Object)SPEC_URL.resolve(Uri.parse((String)"/bar")), (Object)view.getHref());
    }

    @Test
    public void authAttributes() throws Exception {
        String xml = "<Content type='html' sign_owner='false' sign_viewer='false' foo='bar' yo='momma' sub='__MSG_view__'/>";
        View view = new View("test", Arrays.asList(XmlUtil.parse((String)xml)), SPEC_URL);
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "view", "stuff");
        View substituted = view.substitute(substituter);
        Assert.assertEquals((Object)"bar", substituted.getAttributes().get("foo"));
        Assert.assertEquals((Object)"momma", substituted.getAttributes().get("yo"));
        Assert.assertEquals((Object)"stuff", substituted.getAttributes().get("sub"));
        Assert.assertFalse((String)"sign_owner parsed incorrectly.", (boolean)view.isSignOwner());
        Assert.assertFalse((String)"sign_viewer parsed incorrectly.", (boolean)view.isSignViewer());
    }
}

