/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.net.URI;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.DefaultGadgetSpecFactory;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultGadgetSpecFactoryTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private static final Uri REMOTE_URL = Uri.parse((String)"http://example.org/remote.html");
    private static final String LOCAL_CONTENT = "Hello, local content!";
    private static final String ALT_LOCAL_CONTENT = "Hello, local content!";
    private static final String RAWXML_CONTENT = "Hello, rawxml content!";
    private static final String LOCAL_SPEC_XML = "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>";
    private static final String ALT_LOCAL_SPEC_XML = "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>";
    private static final String RAWXML_SPEC_XML = "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, rawxml content!</Content></Module>";
    private static final String URL_SPEC_XML = "<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='url' href='" + REMOTE_URL + "'/>" + "</Module>";
    private static final GadgetContext NO_CACHE_CONTEXT = new GadgetContext(){

        public boolean getIgnoreCache() {
            return true;
        }

        public URI getUrl() {
            return SPEC_URL.toJavaUri();
        }
    };
    private static final GadgetContext RAWXML_GADGET_CONTEXT = new GadgetContext(){

        public boolean getIgnoreCache() {
            return false;
        }

        public URI getUrl() {
            return SPEC_URL.toJavaUri();
        }

        public String getParameter(String param) {
            if (param.equals("rawxml")) {
                return DefaultGadgetSpecFactoryTest.RAWXML_SPEC_XML;
            }
            return null;
        }
    };
    private static final int MAX_AGE = 10000;
    private final HttpFetcher fetcher = (HttpFetcher)org.easymock.EasyMock.createNiceMock(HttpFetcher.class);
    private final CacheProvider cacheProvider = new LruCacheProvider(5);
    private final DefaultGadgetSpecFactory specFactory = new DefaultGadgetSpecFactory(this.fetcher, this.cacheProvider, 10000L);

    @Test
    public void specFetched() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        HttpResponse response = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        GadgetSpec spec = this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void specFetchedWithContext() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        HttpResponse response = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        GadgetSpec spec = this.specFactory.getGadgetSpec(NO_CACHE_CONTEXT);
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void specFetchedFromParam() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(false);
        HttpResponse response = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        GadgetSpec spec = this.specFactory.getGadgetSpec(RAWXML_GADGET_CONTEXT);
        Assert.assertEquals((Object)RAWXML_CONTENT, (Object)spec.getView("default").getContent());
        Assert.assertEquals((Object)DefaultGadgetSpecFactory.RAW_GADGET_URI, (Object)spec.getUrl());
    }

    @Test
    public void staleSpecIsRefetched() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        HttpRequest retriedRequest = new HttpRequest(SPEC_URL).setIgnoreCache(false);
        HttpResponse expiredResponse = new HttpResponseBuilder().addHeader("Pragma", "no-cache").setResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>".getBytes("UTF-8")).create();
        HttpResponse updatedResponse = new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)expiredResponse).once();
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(retriedRequest)).andReturn((Object)updatedResponse).once();
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
        GadgetSpec spec = this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), false);
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void staleSpecReturnedFromCacheOnError() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        HttpRequest retriedRequest = new HttpRequest(SPEC_URL).setIgnoreCache(false);
        HttpResponse expiredResponse = new HttpResponseBuilder().setResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>".getBytes("UTF-8")).addHeader("Pragma", "no-cache").create();
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)expiredResponse);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(retriedRequest)).andReturn((Object)HttpResponse.notFound()).once();
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
        GadgetSpec spec = this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), false);
        Assert.assertEquals((Object)"Hello, local content!", (Object)spec.getView("default").getContent());
    }

    @Test
    public void ttlPropagatesToFetcher() throws Exception {
        CapturingFetcher capturingFetcher = new CapturingFetcher();
        DefaultGadgetSpecFactory forcedCacheFactory = new DefaultGadgetSpecFactory((HttpFetcher)capturingFetcher, this.cacheProvider, 10000L);
        forcedCacheFactory.getGadgetSpec(SPEC_URL.toJavaUri(), false);
        Assert.assertEquals((long)10L, (long)capturingFetcher.request.getCacheTtl());
    }

    @Test
    public void typeUrlNotFetchedRemote() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        HttpResponse response = new HttpResponse(URL_SPEC_XML);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        GadgetSpec spec = this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
        Assert.assertEquals((Object)REMOTE_URL, (Object)spec.getView("default").getHref());
        Assert.assertEquals((Object)"", (Object)spec.getView("default").getContent());
    }

    @Test(expected=GadgetException.class)
    public void badFetchThrows() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)HttpResponse.error());
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
    }

    @Test(expected=GadgetException.class)
    public void badFetchServesCached() throws Exception {
        HttpRequest firstRequest = new HttpRequest(SPEC_URL).setIgnoreCache(false);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(firstRequest)).andReturn((Object)new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>")).once();
        HttpRequest secondRequest = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(secondRequest)).andReturn((Object)HttpResponse.error()).once();
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        GadgetSpec original = this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), false);
        GadgetSpec cached = this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
        Assert.assertEquals((Object)original.getUrl(), (Object)cached.getUrl());
        Assert.assertEquals((Object)original.getChecksum(), (Object)cached.getChecksum());
    }

    @Test(expected=GadgetException.class)
    public void malformedGadgetSpecThrows() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)new HttpResponse("malformed junk"));
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
    }

    @Test(expected=GadgetException.class)
    public void malformedGadgetSpecIsCachedAndThrows() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(false);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andReturn((Object)new HttpResponse("malformed junk")).once();
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        try {
            this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), false);
            Assert.fail((String)"No exception thrown on bad parse");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
        this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), false);
    }

    @Test(expected=GadgetException.class)
    public void throwingFetcherRethrows() throws Exception {
        HttpRequest request = new HttpRequest(SPEC_URL).setIgnoreCache(true);
        org.easymock.EasyMock.expect((Object)this.fetcher.fetch(request)).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT));
        EasyMock.replay((Object[])new Object[]{this.fetcher});
        this.specFactory.getGadgetSpec(SPEC_URL.toJavaUri(), true);
    }

    private static class CapturingFetcher
    implements HttpFetcher {
        HttpRequest request;

        private CapturingFetcher() {
        }

        public HttpResponse fetch(HttpRequest request) {
            this.request = request;
            return new HttpResponse("<Module>  <ModulePrefs title='GadgetSpecFactoryTest'/>  <Content type='html'>Hello, local content!</Content></Module>");
        }
    }
}

