/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.junit.Assert;
import org.junit.Test;

public class HttpResponseBuilderTest {
    @Test
    public void copyConstructor() {
        HttpResponseBuilder builder = new HttpResponseBuilder().setHttpStatusCode(404).setMetadata("foo", "bar").addHeader("Foo-bar", "baz");
        HttpResponseBuilder builder2 = new HttpResponseBuilder(builder);
        Assert.assertEquals((Object)builder.create(), (Object)builder2.create());
    }

    @Test
    public void addHeader() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Foo-bar", "baz");
        Assert.assertEquals((Object)"baz", ((List)builder.getHeaders().get("Foo-bar")).iterator().next());
    }

    @Test
    public void addHeadersMap() {
        ImmutableMap headers = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"blah", (Object)"blah");
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeaders((Map)headers);
        Assert.assertEquals(Arrays.asList("bar"), builder.getHeaders().get("foo"));
        Assert.assertEquals(Arrays.asList("blah"), builder.getHeaders().get("blah"));
    }

    @Test
    public void addAllHeaders() {
        HashMap headers = Maps.newHashMap();
        ArrayList foo = Lists.newArrayList((Object[])new String[]{"bar", "blah"});
        ArrayList bar = Lists.newArrayList((Object[])new String[]{"baz"});
        headers.put("foo", foo);
        headers.put("bar", bar);
        HttpResponseBuilder builder = new HttpResponseBuilder().addAllHeaders((Map)headers);
        Assert.assertTrue((boolean)((List)builder.getHeaders().get("foo")).containsAll(foo));
        Assert.assertTrue((boolean)((List)builder.getHeaders().get("bar")).containsAll(bar));
    }

    @Test
    public void setExpirationTime() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Pragma", "no-cache").addHeader("Cache-Control", "public,max-age=100").setExpirationTime(100);
        Map headers = builder.getHeaders();
        Assert.assertTrue((String)"No Expires header added.", (boolean)headers.containsKey("Expires"));
        Assert.assertFalse((String)"Pragma header not removed", (boolean)headers.containsKey("Pragma"));
        Assert.assertFalse((String)"Cache-Control header not removed", (boolean)headers.containsKey("Cache-Control"));
    }

    @Test
    public void setCacheTtl() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Pragma", "no-cache").addHeader("Expires", "some time stamp normally goes here").setCacheTtl(100);
        Map headers = builder.getHeaders();
        Assert.assertFalse((String)"Expires header not removed.", (boolean)headers.containsKey("Expires"));
        Assert.assertFalse((String)"Pragma header not removed", (boolean)headers.containsKey("Pragma"));
        Assert.assertEquals((Object)"public,max-age=100", ((List)headers.get("Cache-Control")).get(0));
    }

    @Test
    public void setStrictNoCache() {
        HttpResponseBuilder builder = new HttpResponseBuilder().addHeader("Cache-Control", "public,max-age=100").addHeader("Expires", "some time stamp normally goes here").setStrictNoCache();
        Map headers = builder.getHeaders();
        Assert.assertFalse((String)"Expires header not removed.", (boolean)headers.containsKey("Expires"));
        Assert.assertEquals((Object)"no-cache", ((List)headers.get("Cache-Control")).iterator().next());
        Assert.assertEquals((Object)"no-cache", ((List)headers.get("Pragma")).get(0));
    }

    @Test
    public void setResponseString() {
        HttpResponse resp = new HttpResponseBuilder().setResponseString("foo").create();
        Assert.assertEquals((Object)"foo", (Object)resp.getResponseAsString());
    }
}

